/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class DeactivateCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null player. Big Failure. Report to admin immediately.", Username, true);
            return;
        }
        int currentStatus = p.getDutyStatus();
        if (currentStatus == 2) {
            CampaignMain.cm.toUser("AM:You're already on reserve duty.", Username, true);
            return;
        }
        if (currentStatus == 4) {
            CampaignMain.cm.toUser("AM:You're currently fighting! You cannot go into the reserve!", Username, true);
            return;
        }
        if (System.currentTimeMillis() - p.getActiveSince() < Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L) {
            CampaignMain.cm.toUser("AM:You haven't even reached the front yet! (Must meet minimum activity requirement before deactivating)", Username, true);
            return;
        }
        p.setActive(false);
        CampaignMain.cm.toUser("AM:[*] You've left active duty and are now in reserve.", Username, true);
        CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
    }
}

