/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.Planet;
import common.util.UnitUtils;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.util.HouseRankingHelpContainer;
import server.util.MWPasswd;

public class DefectCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreTokens()) {
            boolean replaceWithFaction;
            boolean allowDamagedUnits;
            boolean isSingleFaction = CampaignMain.cm.getBooleanConfig("AllowSinglePlayerFactions");
            String HouseName = command.nextToken();
            String shortName = "";
            boolean commandConfirmed = false;
            boolean bl = allowDamagedUnits = CampaignMain.cm.isUsingAdvanceRepair() && CampaignMain.cm.getBooleanConfig("AllowDonatingOfDamagedUnits");
            if (command.hasMoreElements() && ((String)command.nextElement()).equals("CONFIRM")) {
                commandConfirmed = true;
            }
            if (command.hasMoreTokens()) {
                shortName = command.nextToken();
            }
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            if (CampaignMain.cm.getMarket().hasActiveListings(p)) {
                CampaignMain.cm.toUser("AM:You are not allowed to defect while you have units on the black market.", Username, true);
                return;
            }
            if (CampaignMain.cm.isSynchingBB() && !p.isValidated()) {
                CampaignMain.cm.toUser("AM:You are not allowed to defect until you validate your account.  You received an email when you registered, please use the validateemail command to enter the required code.", Username, true);
                return;
            }
            if (!isSingleFaction && CampaignMain.cm.getData().getHouseByName(HouseName) == null) {
                CampaignMain.cm.toUser("AM:Could not find a faction with that name. Try again?", Username, true);
                return;
            }
            SHouse newHouse = (SHouse)CampaignMain.cm.getData().getHouseByName(HouseName);
            SHouse oldHouse = p.getMyHouse();
            if (!oldHouse.getHouseDefectionFrom()) {
                CampaignMain.cm.toUser("AM:You may not defect from this faction!", Username, true);
                return;
            }
            if (newHouse != null && !newHouse.getHouseDefectionTo()) {
                CampaignMain.cm.toUser("AM:You may not defect to the " + HouseName + " faction.", Username, true);
                return;
            }
            if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
                CampaignMain.cm.toUser("AM:You may not defect while playing a game. Try again after your game is finished.", Username, true);
                return;
            }
            if (p.getDutyStatus() == 3) {
                CampaignMain.cm.toUser("AM:You may not defect while active. Try again after you've returned to reserve.", Username, true);
                return;
            }
            int mercEXPRequired = CampaignMain.cm.getIntegerConfig("MinEXPforMercenaries") - 10 * (int)(p.getRating() - 1600.0);
            int minEXPRequired = CampaignMain.cm.getIntegerConfig("MinEXPforDefecting");
            TreeSet<HouseRankingHelpContainer> s = CampaignMain.cm.getHouseRanking();
            int factionPlace = s.size();
            for (HouseRankingHelpContainer h : s) {
                --factionPlace;
                if (!h.getHouse().equals(newHouse)) continue;
                minEXPRequired += factionPlace * CampaignMain.cm.getIntegerConfig("EXPNeededPerHouseRank");
            }
            if (p.getExperience() < minEXPRequired) {
                CampaignMain.cm.toUser("AM:You're too inexperienced to defect. You need at least " + minEXPRequired + " XP to join that faction.", p.getName(), true);
                return;
            }
            if (newHouse != null && newHouse.equals(oldHouse)) {
                CampaignMain.cm.toUser("AM:You're already in that faction!", p.getName(), true);
                return;
            }
            if (newHouse != null && p.getExperience() < mercEXPRequired && newHouse.isMercHouse()) {
                if (new Boolean(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
                    CampaignMain.cm.toUser("AM:You're too inexperienced to defect to a Mercenary faction!", p.getName(), true);
                } else {
                    CampaignMain.cm.toUser("AM:You're too inexperienced to defect to a Mercenary faction!  You need " + mercEXPRequired + " experience with your current Rating!", p.getName(), true);
                }
                return;
            }
            if (newHouse != null && newHouse.isNewbieHouse()) {
                CampaignMain.cm.toUser("AM:You may not defect back to the training faction.", Username, true);
                return;
            }
            boolean regged = false;
            try {
                MWPasswd.getRecord(p.getName(), null);
            }
            catch (Exception ex) {
                regged = true;
            }
            if (!regged) {
                CampaignMain.cm.toUser("AM:<br>-----<br>You may not join a faction until you set a password for your account. Click [<a href=\"MWREG\">HERE</a>] to register.<br>NOTE: Passwords must be between 4 and 10 characters in length, and should use standard ASCII characters.<br>-----", Username, true);
                return;
            }
            boolean penalizeDefection = true;
            if (oldHouse.isNewbieHouse()) {
                penalizeDefection = false;
            }
            if (newHouse != null && newHouse.isMercHouse() && !CampaignMain.cm.getBooleanConfig("PenalizeDefectToMerc")) {
                penalizeDefection = false;
            }
            if (newHouse != null && !newHouse.isConquerable() && !CampaignMain.cm.getBooleanConfig("PenalizeDefectToNonConq")) {
                penalizeDefection = false;
            }
            int oldExp = p.getExperience();
            int oldMoney = p.getMoney();
            int oldFlu = p.getInfluence();
            int oldRP = p.getReward();
            int newExp = 0;
            int newMoney = 0;
            int newFlu = 0;
            int newRP = 0;
            int expLoss = 0;
            int mnyLoss = 0;
            int fluLoss = 0;
            int rwdLoss = 0;
            int startingUnits = p.getUnits().size();
            int unitsToLose = 0;
            int varsWhichChange = 0;
            boolean solToBeReset = p.getMyHouse().isNewbieHouse() && CampaignMain.cm.getBooleanConfig("ReplaceUnitsLeavingSOL");
            boolean bl2 = replaceWithFaction = p.getMyHouse().isNewbieHouse() && CampaignMain.cm.getBooleanConfig("FactionUnitsLeavingSOL");
            if (penalizeDefection) {
                int expLossPerc = CampaignMain.cm.getIntegerConfig("DefectionEXPLossPercent");
                int expLossFlat = CampaignMain.cm.getIntegerConfig("DefectionEXPLossFlat");
                int mnyLossPerc = CampaignMain.cm.getIntegerConfig("DefectionCBillLossPercent");
                int mnyLossFlat = CampaignMain.cm.getIntegerConfig("DefectionCBillLossFlat");
                int fluLossPerc = CampaignMain.cm.getIntegerConfig("DefectionInfluenceLossPercent");
                int fluLossFlat = CampaignMain.cm.getIntegerConfig("DefectionInfluenceLossFlat");
                int rwdLossPerc = CampaignMain.cm.getIntegerConfig("DefectionRewardLossPercent");
                int rwdLossFlat = CampaignMain.cm.getIntegerConfig("DefectionRewardLossFlat");
                int unitLossPerc = CampaignMain.cm.getIntegerConfig("DefectionUnitLossPercent");
                int unitLossFlat = CampaignMain.cm.getIntegerConfig("DefectionUnitLossFlat");
                if (expLossPerc > 0) {
                    newExp = oldExp * (100 - expLossPerc) / 100;
                } else {
                    newExp = oldExp - expLossFlat;
                    if (newExp < 0) {
                        newExp = 0;
                    }
                }
                expLoss = oldExp - newExp;
                if (expLoss > 0) {
                    ++varsWhichChange;
                }
                if (mnyLossPerc > 0) {
                    newMoney = oldMoney * (100 - mnyLossPerc) / 100;
                } else {
                    newMoney = oldMoney - mnyLossFlat;
                    if (newMoney < 0) {
                        newMoney = 0;
                    }
                }
                mnyLoss = oldMoney - newMoney;
                if (mnyLoss > 0) {
                    ++varsWhichChange;
                }
                if (fluLossPerc > 0) {
                    newFlu = oldFlu * (100 - fluLossPerc) / 100;
                } else {
                    newFlu = oldFlu - fluLossFlat;
                    if (newFlu < 0) {
                        newFlu = 0;
                    }
                }
                fluLoss = oldFlu - newFlu;
                if (fluLoss > 0) {
                    ++varsWhichChange;
                }
                if (rwdLossPerc > 0) {
                    newRP = oldRP * (100 - rwdLossPerc) / 100;
                } else {
                    newRP = oldRP - rwdLossFlat;
                    if (newRP < 0) {
                        newRP = 0;
                    }
                }
                rwdLoss = oldRP - newRP;
                if (rwdLoss > 0) {
                    ++varsWhichChange;
                }
                if (unitLossPerc > 0) {
                    unitsToLose = startingUnits * unitLossPerc / 100;
                } else {
                    unitsToLose = unitLossFlat;
                    if (unitsToLose > startingUnits) {
                        unitsToLose = startingUnits;
                    }
                }
            }
            int varsAddedToString = 0;
            String penString = "";
            if (penalizeDefection && varsWhichChange > 0) {
                penString = "";
                if (expLoss > 0) {
                    penString = penString + expLoss + " XP";
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (mnyLoss > 0) {
                    penString = penString + CampaignMain.cm.moneyOrFluMessage(true, false, mnyLoss);
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (fluLoss > 0) {
                    penString = penString + CampaignMain.cm.moneyOrFluMessage(false, false, fluLoss);
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (rwdLoss > 0) {
                    penString = penString + rwdLoss + " Reward Points";
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
            }
            if (!commandConfirmed) {
                if (!penalizeDefection && !solToBeReset) {
                    CampaignMain.cm.toUser("AM:Click [<a href=\"MWDEFECTDLG/c defect#" + HouseName + "#CONFIRM#" + shortName + "\">here</a>] to confirm your defection to " + HouseName + ".<br>", p.getName(), true);
                    return;
                }
                if (solToBeReset && !replaceWithFaction) {
                    CampaignMain.cm.toUser("AM:Click [<a href=\"MWDEFECTDLG/c defect#" + HouseName + "#CONFIRM#" + shortName + "\">here</a>] to confirm your defection to " + HouseName + ". Your units will be reset.<br>", p.getName(), true);
                    return;
                }
                if (solToBeReset && replaceWithFaction) {
                    CampaignMain.cm.toUser("AM:Click [<a href=\"MWDEFECTDLG/c defect#" + HouseName + "#CONFIRM#" + shortName + "\">here</a>] to confirm your defection to " + HouseName + ". " + HouseName + " will replace your units.", p.getName(), true);
                    return;
                }
                if (varsWhichChange == 0 && unitsToLose == 0) {
                    CampaignMain.cm.toUser("AM:Click [<a href=\"MWDEFECTDLG/c defect#" + HouseName + "#CONFIRM#" + shortName + "\">here</a>] to confirm your defection to " + HouseName + ".<br>", p.getName(), true);
                    return;
                }
                String toReturn = "If you defect to " + HouseName + "  you will lose " + penString;
                if (varsWhichChange != 0) {
                    toReturn = toReturn + " and ";
                }
                toReturn = unitsToLose == startingUnits ? toReturn + "all of your units." : (unitsToLose > 0 ? toReturn + unitsToLose + " units." : toReturn.trim() + ".");
                toReturn = toReturn + " Click [<a href=\"MWDEFECTDLG/c defect#" + HouseName + "#CONFIRM\">here</a>] to confirm your defection to " + HouseName + ".<br>";
                CampaignMain.cm.toUser(toReturn, p.getName(), true);
                return;
            }
            if (newHouse == null && isSingleFaction) {
                if (HouseName.trim().length() < 5) {
                    CampaignMain.cm.toUser("Your faction name must be Greater then 4 characters long!", Username);
                    return;
                }
                if (shortName.trim().length() < 2) {
                    CampaignMain.cm.toUser("Your factions short name needs be to 2 or more characters long!", Username);
                    return;
                }
                newHouse = this.createSingleFaction(HouseName, shortName);
                if (newHouse == null) {
                    CampaignMain.cm.toUser("Sorry but their is already a house with the name of " + HouseName + " please try again.", Username);
                    return;
                }
                newHouse.addLeader(Username);
            }
            String toReturn = "You succesfully defected to " + HouseName + ".<br>";
            if (isSingleFaction && !newHouse.getPlanets().values().isEmpty()) {
                toReturn = toReturn + "You've inherited planet ";
                for (SPlanet planet : newHouse.getPlanets().values()) {
                    toReturn = toReturn + planet.getNameAsColoredLink();
                }
                toReturn = toReturn + "<br>";
            }
            if (penalizeDefection && (unitsToLose > 0 || varsWhichChange > 0) || solToBeReset) {
                if (solToBeReset) {
                    NewbieHouse nh = (NewbieHouse)p.getMyHouse();
                    if (replaceWithFaction) {
                        nh.requestNewMech(p, true, HouseName);
                    } else {
                        nh.requestNewMech(p, true, null);
                    }
                    toReturn = toReturn + "Your units ";
                    if (CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues")) {
                        toReturn = toReturn + " and pilot queue ";
                    }
                    toReturn = toReturn + "were reset";
                } else {
                    p.addExperience(-expLoss, false);
                    p.addMoney(-mnyLoss);
                    p.setInfluence(newFlu);
                    p.setReward(newRP);
                    toReturn = toReturn + "You've lost " + penString;
                    StringBuilder hsUpdates = new StringBuilder();
                    boolean damaged = false;
                    if (unitsToLose == startingUnits) {
                        for (SUnit currU : p.getUnits()) {
                            boolean bl3 = damaged = !UnitUtils.canStartUp(currU.getEntity()) || UnitUtils.hasArmorDamage(currU.getEntity()) || UnitUtils.hasCriticalDamage(currU.getEntity());
                            if ((!damaged || !allowDamagedUnits) && damaged) continue;
                            hsUpdates.append(oldHouse.addUnit(currU, false));
                        }
                        p.stripOfAllUnits(false);
                        toReturn = toReturn + " and all of your units";
                    } else if (unitsToLose > 0) {
                        toReturn = toReturn + " and the following units: ";
                        for (int numRemoved = 0; numRemoved < unitsToLose; ++numRemoved) {
                            if (numRemoved != 0) {
                                toReturn = toReturn + ", ";
                            }
                            SUnit toRemove = p.getUnits().get(CampaignMain.cm.getRandomNumber(p.getUnits().size()));
                            toReturn = toReturn + toRemove.getModelName();
                            boolean bl4 = damaged = !UnitUtils.canStartUp(toRemove.getEntity()) || UnitUtils.hasArmorDamage(toRemove.getEntity()) || UnitUtils.hasCriticalDamage(toRemove.getEntity());
                            if (damaged && allowDamagedUnits || !damaged) {
                                hsUpdates.append(oldHouse.addUnit(toRemove, false));
                            }
                            p.removeUnit(toRemove.getId(), false);
                        }
                    }
                    if (hsUpdates.length() > 0) {
                        CampaignMain.cm.doSendToAllOnlinePlayers(oldHouse, "HS|" + hsUpdates.toString(), false);
                    }
                }
                toReturn = toReturn + ".";
            }
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.clearArmies(p.getDBId());
            }
            p.getMyHouse().removeLeader(p.getName());
            String clientVersion = p.getPlayerClientVersion();
            if (CampaignMain.cm.isSynchingBB()) {
                CampaignMain.cm.MySQL.removeUserFromHouseForum(p.getForumID(), p.getMyHouse().getForumID());
                CampaignMain.cm.MySQL.addUserToHouseForum(p.getForumID(), newHouse.getForumID());
            }
            p.getMyHouse().removePlayer(p, false);
            p.setMyHouse(newHouse);
            p.setSubFaction(newHouse.getZeroLevelSubFaction());
            CampaignMain.cm.toUser(toReturn, Username, true);
            CampaignMain.cm.doSendHouseMail(oldHouse, "NOTE: ", p.getName() + " defected to " + HouseName);
            CampaignMain.cm.doSendHouseMail(newHouse, "NOTE: ", p.getName() + " joined the faction! (Defected from " + oldHouse.getName() + ")");
            CampaignMain.cm.addToNewsFeed(Username + " defected from " + oldHouse.getName() + " to " + HouseName);
            if (p.getMyLogo().trim().equals(oldHouse.getLogo().trim())) {
                p.setMyLogo(newHouse.getLogo().trim());
            }
            if (p.getMyHouse().equals(newHouse) && !CampaignMain.cm.getServer().isAdmin(Username) && !isSingleFaction) {
                MWPasswd.getRecord(Username).setAccess(2);
            }
            for (SUnit currU : p.getUnits()) {
                SUnit.checkAmmoForUnit(currU, newHouse);
            }
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.clearArmies(p.getDBId());
            }
            CampaignMain.cm.forceSavePlayer(p);
            CampaignMain.cm.doLoginPlayer(Username);
            CampaignMain.cm.toUser("SP|Welcome to " + HouseName + "!", p.getName(), false);
            if (p.getFreeBays() < 0) {
                p.setRandomUnmaintained();
                int factionBays = p.getMyHouse().getBaysProvided();
                int minBays = CampaignMain.cm.getIntegerConfig("MinimumHouseBays");
                String dismayMessage = "You are dismayed when you discover that " + p.getMyHouse().getName() + " only has ";
                dismayMessage = minBays > factionBays ? dismayMessage + minBays : dismayMessage + factionBays;
                dismayMessage = CampaignMain.cm.isUsingAdvanceRepair() ? dismayMessage + " bays to house your units. You'll have to buy more bays if you want to go active!" : dismayMessage + " technicians avaliable to assign to your force. You order your techs to ignore the maintaince needs of some units, adjust the duty roster, and consider hiring moretechnicians ... (Some units are now unmaintained! Check your status!)";
                CampaignMain.cm.toUser(dismayMessage, Username, true);
            }
            p.setPlayerClientVersion(clientVersion);
            CampaignMain.cm.forceSavePlayer(p);
        }
    }

    public SHouse createSingleFaction(String houseName, String shortName) {
        SHouse house = new SHouse();
        int maxHouseName = CampaignMain.cm.getIntegerConfig("MaxFactionName");
        int maxShortName = CampaignMain.cm.getIntegerConfig("MaxFactionShortName");
        if (houseName.length() > maxHouseName) {
            houseName = houseName.substring(0, maxHouseName);
        }
        if (shortName.length() > maxShortName) {
            shortName = shortName.substring(0, maxShortName);
        }
        if (CampaignMain.cm.getData().getHouseByName(houseName) != null) {
            return null;
        }
        house.createNoneHouse();
        house.setName(houseName);
        house.setAbbreviation(shortName);
        house.setBaseGunner(4);
        house.setBasePilot(5);
        house.setConquerable(true);
        house.setTechLevel(0);
        CampaignMain.cm.addHouse(house);
        CampaignMain.cm.doSendToAllOnlinePlayers("PL|ANH|" + house.addNewHouse(), false);
        for (int type = 0; type < 6; ++type) {
            for (int weight = 0; weight <= 3; ++weight) {
                house.addPP(weight, type, CampaignMain.cm.getIntegerConfig("BaseFactoryComponents"), false);
            }
        }
        this.findEmptyPlanet(house);
        house.updated();
        return house;
    }

    public void findEmptyPlanet(SHouse house) {
        LinkedList<Planet> planetList = new LinkedList<Planet>();
        for (Planet newPlanet : CampaignMain.cm.getData().getAllPlanets()) {
            int totalCP = newPlanet.getConquestPoints();
            if (newPlanet.getInfluence().getInfluence(-1) != totalCP) continue;
            planetList.add(newPlanet);
        }
        if (planetList.size() < 1) {
            CampaignData.mwlog.errLog("Error Unable to find planet for new faction " + house.getName());
            CampaignMain.cm.doSendModMail("NOTE", "Error Unable to find planet for new faction " + house.getName());
        }
        String[] factoryNames = new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lamda", "Mu", "Nu", "Xi", "Omikron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega"};
        int planetNumber = CampaignMain.cm.getRandomNumber(planetList.size());
        SPlanet planet = (SPlanet)planetList.get(planetNumber);
        planet.setConquestPoints(1000);
        planet.setCompProduction(1000);
        int baseCommonBuildTableShare = CampaignMain.cm.getIntegerConfig("BaseCommonBuildTableShares");
        for (int weight = 0; weight <= 3; ++weight) {
            for (int type = 0; type < 6; ++type) {
                String weightName = SUnit.getWeightClassDesc(weight);
                String typeName = SUnit.getTypeClassDesc(type);
                int maxFactories = CampaignMain.cm.getIntegerConfig("Starting" + weightName + typeName + "Factory");
                int factoryType = 1;
                switch (type) {
                    case 1: {
                        factoryType = 2;
                        break;
                    }
                    case 2: {
                        factoryType = 4;
                        break;
                    }
                    case 4: {
                        factoryType = 16;
                        break;
                    }
                    case 5: {
                        factoryType = 33;
                        break;
                    }
                    case 3: {
                        factoryType = 8;
                        break;
                    }
                    default: {
                        factoryType = 1;
                    }
                }
                for (int count = 0; count < maxFactories; ++count) {
                    String factoryName = factoryNames[count] + " " + weightName + " " + typeName + " Factory";
                    SUnitFactory factory = new SUnitFactory(factoryName, planet, weightName, house.getName(), 0, CampaignMain.cm.getIntegerConfig("BaseFactoryRefreshRate"), factoryType, "standard", 0);
                    planet.getUnitFactories().add(factory);
                }
                try {
                    String buildTableName = "./data/buildtables/standard/";
                    String rewardbuildTableName = "./data/buildtables/reward/";
                    if (type == 0) {
                        buildTableName = buildTableName + house.getName() + "_" + weightName + ".txt";
                        rewardbuildTableName = rewardbuildTableName + house.getName() + "_" + weightName + ".txt";
                    } else {
                        buildTableName = buildTableName + house.getName() + "_" + weightName + typeName + ".txt";
                        rewardbuildTableName = rewardbuildTableName + house.getName() + "_" + weightName + typeName + ".txt";
                    }
                    FileOutputStream out = new FileOutputStream(buildTableName);
                    PrintStream ps = new PrintStream(out);
                    ps.println(baseCommonBuildTableShare + " Common");
                    ps.close();
                    out.close();
                    out = new FileOutputStream(rewardbuildTableName);
                    ps = new PrintStream(out);
                    ps.println(baseCommonBuildTableShare + " Common");
                    ps.close();
                    out.close();
                    continue;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        }
        HashMap<Integer, Integer> flu = new HashMap<Integer, Integer>();
        flu.put(house.getId(), planet.getConquestPoints());
        planet.getInfluence().setInfluence(flu);
        planet.setBaysProvided(CampaignMain.cm.getIntegerConfig("StartingPlanetBays"));
        planet.setOwner(null, planet.checkOwner(), true);
        house.setInitialHouseRanking(planet.getConquestPoints());
        planet.updated();
    }
}

