/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OpsChickenThread;
import server.campaign.operations.ShortOperation;

public class DefendCommand
implements Command {
    int accessLevel = 0;
    String syntax = "attack number#army number#team number";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int altID;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        int armyID = -1;
        int teamNumber = -1;
        boolean isAttacker = false;
        try {
            opID = Integer.parseInt(command.nextToken());
            armyID = Integer.parseInt(command.nextToken());
            teamNumber = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c defend#" + this.syntax, Username, true);
            return;
        }
        SPlayer dp = CampaignMain.cm.getPlayer(Username);
        if (dp == null) {
            CampaignMain.cm.toUser("AM:Null player. Report this immediately!", Username, true);
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
        if (so == null) {
            CampaignMain.cm.toUser("AM:Defend failed. Attack #" + opID + " does not exist.", Username, true);
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
        SArmy da = dp.getArmy(armyID);
        if (da == null) {
            if (o.getBooleanValue("MULArmiesOnly")) {
                da = new SArmy(-1, Username);
            } else {
                CampaignMain.cm.toUser("AM:Defend failed. Army #" + armyID + " does not exist.", Username, true);
                return;
            }
        }
        if (dp.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        if (da != null && da.isDisabled()) {
            CampaignMain.cm.toUser("AM: Defend failed.  Army #" + armyID + " is disabled and cannot be used to defend.", Username, true);
            return;
        }
        if (dp.getDutyStatus() != 3) {
            CampaignMain.cm.toUser("AM:Defend failed. You must be active to defend against an attack.", Username, true);
            return;
        }
        if (so.getStatus() != ShortOperation.STATUS_WAITING) {
            if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
                CampaignMain.cm.toUser("AM:Defend failed. Attack #" + opID + " is finished.", Username, true);
                return;
            }
            CampaignMain.cm.toUser("AM:Defend failed. Attack #" + opID + " is already defended.", Username, true);
            return;
        }
        OpsChickenThread pThread = so.getChickenThreads().get(dp.getName().toLowerCase());
        if (pThread == null || !pThread.getArmies().contains(da)) {
            SPlayer attacker = CampaignMain.cm.getPlayer(so.getAttackers().firstKey());
            SArmy aa = attacker.getArmy(so.getAttackers().get(so.getAttackers().firstKey()));
            boolean isAnOpponent = false;
            for (SArmy currA : da.getOpponents()) {
                if (!currA.equals(aa)) continue;
                isAnOpponent = true;
                break;
            }
            if (!isAnOpponent) {
                CampaignMain.cm.toUser("AM:Defend failed. Army #" + da.getID() + " is not an opponent " + "for the army in Attack #" + so.getShortID() + ". BV's do not match.", Username, true);
                return;
            }
            String s = CampaignMain.cm.getOpsManager().validateShortDefense(dp, da, o, null);
            if (s != null && !s.trim().equals("")) {
                CampaignMain.cm.toUser("AM:Defend failed " + s, Username, true);
                return;
            }
        }
        if (o.getBooleanValue("TeamOperation")) {
            if (teamNumber < 1 || teamNumber > 8) {
                CampaignMain.cm.toUser("Invalid Team Number! Try again!", Username);
                CampaignMain.cm.toUser(so.getChickenThreads().get(Username.toLowerCase()).generateAttackDialogCall(), Username, false);
                return;
            }
            int bv = 0;
            String message = "";
            if (o.getBooleanValue("TeamsMustBeSameFaction")) {
                teamNumber = so.getFactionTeam(dp.getHouseFightingFor().getName());
                message = so.checkTeam(teamNumber, bv = da.getBV(), false);
                if (message.trim().length() > 0) {
                    CampaignMain.cm.toUser(message, Username);
                    CampaignMain.cm.toUser(so.getChickenThreads().get(Username.toLowerCase()).generateAttackDialogCall(), Username, false);
                    return;
                }
            } else if (o.getBooleanValue("RandomTeamDetermination")) {
                int numberOfTeams = Math.max(2, Math.min(8, o.getIntValue("NumberOfTeams")));
                teamNumber = numberOfTeams + 1;
                for (int team = 1; team <= numberOfTeams; ++team) {
                    if (so.checkTeam(team).trim().length() >= 1) continue;
                    teamNumber = team;
                    break;
                }
                if (teamNumber > numberOfTeams) {
                    CampaignMain.cm.toUser("Sorry but a team could not be found for you.", Username);
                    return;
                }
            }
            dp.setTeamNumber(teamNumber);
            CampaignMain.cm.toUser("PL|STN|" + teamNumber, Username, false);
            CampaignMain.cm.toUser("AM:You've been assigned to team #" + teamNumber + ".", Username);
        }
        if (teamNumber > 0 && so.getAttackersTeam() == teamNumber) {
            so.addAttacker(dp, da, "");
            CampaignMain.cm.getOpsManager().removePlayerFromAllDefenderLists(dp, so, true);
            isAttacker = true;
        } else {
            so.addDefender(dp, da, "");
            CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(dp, so, true);
            CampaignMain.cm.getOpsManager().removePlayerFromAllDefenderLists(dp, so, true);
        }
        int money = o.getIntValue("DefenderCostMoney");
        int flu = o.getIntValue("DefenderCostInfluence");
        int rp = o.getIntValue("DefenderCostReward");
        String toSend = "AM:You are now ";
        toSend = isAttacker ? toSend + "joining " : toSend + "defending ";
        toSend = toSend + "Attack #" + opID;
        boolean hasCost = false;
        if (money > 0) {
            dp.addMoney(-money);
            toSend = toSend + "(" + CampaignMain.cm.moneyOrFluMessage(true, true, money);
            hasCost = true;
        }
        if (flu > 0) {
            dp.addInfluence(-flu);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + CampaignMain.cm.moneyOrFluMessage(false, true, flu);
            hasCost = true;
        }
        if (rp > 0) {
            dp.addReward(-rp);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + "-" + rp + " RP";
            hasCost = true;
        }
        toSend = hasCost ? toSend + ")." : toSend + ".";
        CampaignData.mwlog.gameLog("Defend: " + so.getShortID() + "/" + dp.getName() + " w. Army #" + da.getID());
        CampaignMain.cm.toUser(toSend, Username, true);
        if (o.getBooleanValue("FreeForAllOperation")) {
            toSend = "AM:" + dp.getName() + " has joined the operation, as ";
            toSend = isAttacker ? toSend + "an attacker." : toSend + "a defender.";
            toSend = toSend + " <a href=\"MEKWARS/c commenceoperation#" + opID + "#CONFIRM\">Click here to commence</a>";
            CampaignMain.cm.toUser(toSend, so.getInitiator().getName(), true);
        }
        if ((altID = CampaignMain.cm.getOpsManager().playerIsAnAttacker(dp)) > 0) {
            ShortOperation attackingOp = CampaignMain.cm.getOpsManager().getRunningOps().get(altID);
            CampaignMain.cm.getOpsManager().terminateOperation(attackingOp, 1, null);
        }
    }
}

