/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class DonateCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int donationsAllowed = Integer.parseInt(house.getConfig("DonationsAllowed"));
        if (donationsAllowed <= 0) {
            CampaignMain.cm.toUser("AM:Donations are not allowed on this server.", Username, true);
            return;
        }
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:SOL Players are not allowed to donate units, sorry!", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("AM:You may not donate any of your units while you are on welfare.", Username, true);
            return;
        }
        int unitid = -1;
        try {
            unitid = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c donate#unitid", Username, true);
            return;
        }
        SUnit m = p.getUnit(unitid);
        if (m == null) {
            CampaignMain.cm.toUser("AM:You do not have a unit with ID#" + unitid + ".", Username, true);
            return;
        }
        if (m.getModelName().startsWith("Error") || m.getModelName().startsWith("OMG")) {
            CampaignMain.cm.toUser("AM:You tried to donate an Error unit. The unit was auto-scrapped and the staff was alerted.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " tried to donate an OMG. Unit auto-scrapped. Data: " + m.getProducer());
            CampaignData.mwlog.errLog(Username + " tried to donate an OMG. Unit auto-scrapped. Data: " + m.getProducer());
            p.removeUnit(unitid, true);
            return;
        }
        if (m.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:Units that are for sale on the Market may not be donated.", Username, true);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(unitid) > 0 && p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not donate units which are in active armies.", Username, true);
            return;
        }
        for (SArmy currA : p.getArmies()) {
            if (!currA.isLocked() || currA.getUnit(unitid) == null) continue;
            CampaignMain.cm.toUser("AM:You may not donate units which are in fighting armies.", Username, true);
            return;
        }
        if (p.getDonationsThisTick() >= donationsAllowed) {
            CampaignMain.cm.toUser("AM:You may only donate " + donationsAllowed + " unit(s) each tick.", Username, true);
            return;
        }
        if (!Boolean.parseBoolean(house.getConfig("AllowDonatingOfDamagedUnits")) && (UnitUtils.hasArmorDamage(m.getEntity()) || UnitUtils.hasCriticalDamage(m.getEntity()))) {
            CampaignMain.cm.toUser("AM:You may not donate damaged units.", Username, true);
            return;
        }
        float costMulti = Float.parseFloat(house.getConfig("DonationCostMultiplier"));
        int moneyToDonate = Math.round((float)p.getMyHouse().getPriceForUnit(m.getWeightclass(), m.getType()) * costMulti);
        int infToDonate = (int)((float)p.getMyHouse().getInfluenceForUnit(m.getWeightclass(), m.getType()) * costMulti);
        if (infToDonate < 0) {
            infToDonate = 0;
        }
        if (p.getMoney() < moneyToDonate || p.getInfluence() < infToDonate) {
            CampaignMain.cm.toUser("AM:You cannot afford to donate this unit. You need " + CampaignMain.cm.moneyOrFluMessage(true, true, moneyToDonate) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, infToDonate) + ".", Username, true);
            return;
        }
        if (m.getScrappableFor() >= 0) {
            p.addMoney(m.getScrappableFor() / 2);
            p.addInfluence(infToDonate / 2);
            CampaignMain.cm.toUser("AM:You donated the " + m.getModelName() + " (" + CampaignMain.cm.moneyOrFluMessage(true, true, m.getScrappableFor() / 2, true) + ", " + CampaignMain.cm.moneyOrFluMessage(false, true, infToDonate / 2, true) + ").", Username, true);
        } else {
            p.addMoney(-moneyToDonate);
            p.addInfluence(-infToDonate);
            p.addDonationThisTick();
            CampaignMain.cm.toUser("AM:You donated the " + m.getModelName() + " (" + CampaignMain.cm.moneyOrFluMessage(true, true, -moneyToDonate, true) + ", " + CampaignMain.cm.moneyOrFluMessage(false, true, -infToDonate, true) + ").", Username, true);
        }
        CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " donated " + StringUtils.aOrAn(m.getVerboseModelName(), true) + " to the faction.");
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " donated a unit and sent himself into welfare.");
        }
        p.removeUnit(unitid, true);
        SPilot oldPilot = (SPilot)m.getPilot();
        if (Boolean.parseBoolean(house.getConfig("AllowPersonalPilotQueues")) && !m.hasVacantPilot() && m.isSinglePilotUnit()) {
            p.getPersonalPilotQueue().addPilot(m.getPilot(), m.getWeightclass());
            CampaignMain.cm.toUser("PL|AP2PPQ|" + m.getType() + "|" + m.getWeightclass() + "|" + oldPilot.toFileFormat("#", true), Username, false);
            CampaignMain.cm.toUser(oldPilot.getName() + " was moved to your barracks.", Username, true);
            p.getPersonalPilotQueue().checkQueueAndWarn(p.getName(), m.getType(), m.getWeightclass());
            m.setPilot(new SPilot("Vacant", 99, 99));
        } else if (!CampaignMain.cm.getBooleanConfig("CrewsStayWithUnits")) {
            p.getMyHouse().addDispossessedPilot(m, false);
            m.setPilot(new SPilot("Vacant", 99, 99));
        }
        p.getMyHouse().addUnit(m, true);
    }
}

