/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.House;
import java.net.InetAddress;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class EnrollCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        if (Username.startsWith("Nobody")) {
            CampaignMain.cm.toUser("AM:Nobodies are not allowed to enroll. If you're signing on for the first time and were labelled a Nobody, you're probably using a name someone else has already registered. If you've registered this name previously, you're either not sending a password or sending an incorrect password. Try changing/removing your password in the configuration menu and connecting again.", Username, true);
            return;
        }
        if (Username.equalsIgnoreCase("DRAW")) {
            CampaignMain.cm.toUser("AM:The name DRAW is reserved for system use. Try another name.", Username, true);
            return;
        }
        if (Username.startsWith("[Dedicated]")) {
            CampaignMain.cm.toUser("AM:Dedicated hosts may not enroll in the campaign.", Username, true);
            return;
        }
        for (House currFaction : CampaignMain.cm.getData().getAllHouses()) {
            if (!Username.equalsIgnoreCase(currFaction.getName())) continue;
            CampaignMain.cm.toUser("AM:You may not enroll in the campaign using the name of an existing faction.", Username, true);
            return;
        }
        if (Username.trim().equalsIgnoreCase("SERVER")) {
            CampaignMain.cm.toUser("AM:The name SERVER is reserved for system use. Try another name.", Username, true);
            return;
        }
        if (Username.indexOf("~") > 0 || Username.indexOf("$") > -1 || Username.indexOf("#") > -1 || Username.indexOf("^") > -1 || Username.indexOf("@") > -1 || Username.indexOf("*") > -1 || Username.indexOf("&") > -1 || Username.indexOf("%") > -1 || Username.indexOf(".") > -1 || Username.indexOf(",") > -1 || Username.indexOf("!") > -1 || Username.indexOf("<") > -1 || Username.indexOf(">") > -1 || Username.indexOf("+") > -1 || Username.indexOf("=") > -1 || Username.indexOf("|") > -1) {
            CampaignMain.cm.toUser("AM:Your name contains one or more illegal charachters. These are  reserved for system use or high-level players (mods, admins). Remove any of  the following and try enrolling again: ~ @ # $ % ^ + = & < > * . , ! |", Username, true);
            return;
        }
        if (CampaignMain.cm.getHouseForPlayer(Username) != null) {
            CampaignMain.cm.toUser("AM:You are already enrolled in the campaign. Nice try though.", Username, true);
            return;
        }
        SHouse h = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null);
        if (h == null) {
            CampaignMain.cm.toUser("AM:Training faction is null. Contact an admin immediately.", Username, true);
            return;
        }
        NewbieHouse nh = null;
        if (h instanceof NewbieHouse) {
            nh = (NewbieHouse)h;
        }
        if (nh == null) {
            CampaignMain.cm.toUser("AM:Named training faction is not a NewbieHouse. Contact an admin immediately.", Username, true);
            return;
        }
        SPlayer newPlayer = new SPlayer();
        newPlayer.setName(Username);
        newPlayer.setMyHouse(nh);
        String unitInfo = nh.getNewSOLUnits(newPlayer, null);
        newPlayer.addMoney(CampaignMain.cm.getIntegerConfig("PlayerBaseMoney"));
        String result = new String("AM:<font color=\"navy\">WELCOME TO MEKWARS!</font><br><br>You've been assigned to " + nh.getNameAsLink() + ", " + "a training faction. Take some time here to learn about the server rules, " + "the unique qualities of the factions that you may join, and the software " + "in general. If you're looking for helpful hints, many servers include " + "a short <b>New Player Guide</b>. Most have active forums. All have veteran " + "players, moderators and admins willing to help new folks learn the ropes.<br><br>" + "You've been assigned a starting force: " + unitInfo + ".<br><br>Have fun!" + "</font><br>");
        CampaignMain.cm.toUser(result, Username, true);
        if (CampaignMain.cm.getServer().getUserLevel(Username) < 2) {
            CampaignMain.cm.toUser("AM:<font color=\"navy\"><br>---<br>NOTE: Your account will not be password protected until you [<a href=\"MWREG\">register</a>] your nickname.<br>---<br></font>", Username, true);
        }
        CampaignMain.cm.doLoginPlayer(Username);
        InetAddress ip = CampaignMain.cm.getServer().getIP(Username);
        CampaignData.mwlog.ipLog("ENROLL: " + Username + " IP: " + ip);
        CampaignMain.cm.doSendModMail("NOTE", Username + " enrolled in the campaign (IP: " + ip + ").");
    }
}

