/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class ExchangePilotInUnitCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            return;
        }
        if (command.hasMoreElements()) {
            SUnit m;
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int mechid = Integer.parseInt(command.nextToken());
            int newPilotId = -1;
            if (command.hasMoreElements()) {
                newPilotId = Integer.parseInt(command.nextToken());
            }
            if ((m = p.getUnit(mechid)) != null) {
                if (!m.isSinglePilotUnit()) {
                    CampaignMain.cm.toUser("AM:You may not remove that pilot from this unit.", Username, true);
                    return;
                }
                if (p.getDutyStatus() == 3 && p.getAmountOfTimesUnitExistsInArmies(mechid) > 0) {
                    CampaignMain.cm.toUser(m.getModelName() + " cannot have its pilot switched out while active and in an exisiting army.", Username, true);
                    return;
                }
                if (m.getPilotIsReparing()) {
                    CampaignMain.cm.toUser(m.getPilot().getName() + " is currently repairing the " + m.getModelName() + " you may not remove them util the job is complete.", Username, true);
                    return;
                }
                SPilot pilot = (SPilot)m.getPilot();
                int capSize = CampaignMain.cm.getIntegerConfig("MaxAllowedPilotsInQueueToBuyFromHouse");
                if (newPilotId == -1 && p.getPersonalPilotQueue().getPilotQueue(m.getType(), m.getWeightclass()).size() >= capSize) {
                    CampaignMain.cm.toUser("AM:There are no free beds in the barracks " + pilot.getName() + " will have to sleep in his unit.", Username);
                    return;
                }
                pilot.setUnitType(m.getType());
                if (!pilot.getName().equals("Vacant")) {
                    p.getPersonalPilotQueue().addPilot(pilot, m.getWeightclass());
                    CampaignMain.cm.toUser("PL|AP2PPQ|" + m.getType() + "|" + m.getWeightclass() + "|" + pilot.toFileFormat("#", true), Username, false);
                    CampaignMain.cm.toUser(pilot.getName() + " was moved from your " + m.getModelName() + " to your barracks.", Username, true);
                }
                SPilot p2 = null;
                if (newPilotId > -1) {
                    try {
                        p2 = (SPilot)p.getPersonalPilotQueue().getPilot(m.getType(), m.getWeightclass(), newPilotId);
                        if (p2 == null) {
                            CampaignMain.cm.toUser("AM:Invalid Pilot try again!", Username, true);
                            return;
                        }
                        CampaignMain.cm.toUser("PL|RPPPQ|" + m.getType() + "|" + m.getWeightclass() + "|" + newPilotId, Username, false);
                        m.setPilot(p2);
                        CampaignMain.cm.toUser(p2.getName() + " is now assigned to the " + m.getModelName() + " [New BV: " + m.getBV() + "].", Username, true);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                        CampaignMain.cm.toUser("AM:Invalid Pilot try again!", Username, true);
                        return;
                    }
                } else {
                    p2 = new SPilot("Vacant", 99, 99);
                    m.setPilot(p2);
                }
                CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), Username, false);
                Enumeration<SArmy> f = p.getArmies().elements();
                while (f.hasMoreElements()) {
                    SArmy currArmy = f.nextElement();
                    if (currArmy.getUnit(m.getId()) == null) continue;
                    currArmy.setBV(0);
                    CampaignMain.cm.toUser("PL|SAD|" + currArmy.toString(true, "%"), Username, false);
                    CampaignMain.cm.getOpsManager().checkOperations(currArmy, true);
                }
            }
        }
    }
}

