/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class ExchangeUnitCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null player. Report this immediately!", Username, true);
            return;
        }
        if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
            CampaignMain.cm.toUser("AM:You may not change an army's composition while you are in a game.", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            SArmy a;
            String parse = (String)command.nextElement();
            StringTokenizer S = new StringTokenizer(parse, ",");
            int position = -1;
            int armyid = Integer.parseInt((String)S.nextElement());
            if (!S.hasMoreElements()) {
                return;
            }
            int mechid = Integer.parseInt((String)S.nextElement());
            int changeid = -1;
            if (command.hasMoreElements()) {
                changeid = Integer.parseInt((String)command.nextElement());
            }
            if ((a = p.getArmy(armyid)) == null) {
                CampaignMain.cm.toUser("AM:You do not have an  Army #" + armyid, Username, true);
                return;
            }
            if (a.isLocked()) {
                CampaignMain.cm.toUser("AM:This Army is currently in a game.", Username, true);
                return;
            }
            if (a.isPlayerLocked()) {
                CampaignMain.cm.toUser("AM:You cannot modify a locked army.", Username, true);
                return;
            }
            SUnit oldMech = (SUnit)a.getUnit(mechid);
            SUnit changeMech = p.getUnit(changeid);
            if (changeMech != null && changeMech.getModelName().startsWith("Error")) {
                CampaignMain.cm.toUser("AM:Error units may not be added to armies.", Username, true);
                return;
            }
            if (changeMech != null && a.isUnitInArmy(changeMech)) {
                CampaignMain.cm.toUser("AM:That unit already exits in Army #" + armyid + ".", Username, true);
                return;
            }
            if (p.getDutyStatus() == 3) {
                CampaignMain.cm.toUser("AM:You may not change your armies while on active duty.", Username, true);
                return;
            }
            if (changeMech != null && changeMech.getStatus() == 2) {
                CampaignMain.cm.toUser("AM:You may not assign unmaintained units to combat formations!", Username, true);
                return;
            }
            if (changeMech != null) {
                int maxAmount = Integer.valueOf(CampaignMain.cm.getConfig("UnitsInMultipleArmiesAmount"));
                if (p.getAmountOfTimesUnitExistsInArmies(changeMech.getId()) >= maxAmount) {
                    if (maxAmount == 1) {
                        CampaignMain.cm.toUser("AM:A unit may only be in one army at a time.", Username, true);
                    } else {
                        CampaignMain.cm.toUser("AM:A unit may be in a maximum of " + maxAmount + " armies.", Username, true);
                    }
                    return;
                }
                if (changeMech.getStatus() == 3) {
                    CampaignMain.cm.toUser("AM:This unit is being sold on the Market. It may not be added to an army.", Username, true);
                    return;
                }
                if (oldMech != null) {
                    int oldID = oldMech.getId();
                    position = a.getUnitPosition(oldID);
                    a.removeUnit(oldID);
                    CampaignMain.cm.toUser("PL|RAU|" + a.getID() + "#" + oldID + "#" + a.getBV(), Username, false);
                    CampaignMain.cm.toUser("PL|UU|" + oldMech.getId() + "|" + oldMech.toString(true), Username, false);
                    a.checkLegalRatio(Username);
                } else {
                    int oldID = mechid;
                }
                if (position > -1) {
                    a.addUnit(changeMech, position);
                    CampaignMain.cm.toUser("PL|AAU|" + a.getID() + "#" + changeMech.getId() + "#" + a.getBV() + "#" + position, Username, false);
                } else {
                    a.addUnit(changeMech);
                    CampaignMain.cm.toUser("PL|AAU|" + a.getID() + "#" + changeMech.getId() + "#" + a.getBV(), Username, false);
                }
                p.resetWeightedArmyNumber();
                a.checkLegalRatio(Username);
            } else if (oldMech != null) {
                a.removeUnit(oldMech.getId());
                CampaignMain.cm.toUser("PL|RAU|" + a.getID() + "#" + oldMech.getId() + "#" + a.getBV(), Username, false);
                a.checkLegalRatio(Username);
                CampaignMain.cm.toUser("PL|UU|" + oldMech.getId() + "|" + oldMech.toString(true), Username, false);
            }
            CampaignMain.cm.toUser("AM:Army #" + a.getID() + " was changed. New BV: " + a.getBV(), Username, true);
            CampaignMain.cm.getOpsManager().checkOperations(a, true);
        }
    }
}

