/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class FireTechsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            this.fireAdvanceTechs(command, Username);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int numtofire = 1;
        try {
            numtofire = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:Couldn't tell how many techs to fire. Check your input. It should be something like this: /c firetechs#3", Username, true);
            return;
        }
        if (p.getTechnicians() < numtofire) {
            CampaignMain.cm.toUser("AM:You tried to fire " + numtofire + " technicians, but you only have " + p.getTechnicians() + " independent techs " + "on your payroll. The rest were assigned to your force by your faction and can't be dismissed.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You may not fire technicians while you are engaged! Wait until your units are out of battle and fully repaired!", Username, true);
            return;
        }
        if (p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not fire technicians while you are active! Withdraw from the front lines before reducing your support levels!", Username, true);
            return;
        }
        p.addTechnicians(-numtofire);
        if (numtofire == 1) {
            CampaignMain.cm.toUser("AM:You fire 1 technician.", Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You fired " + numtofire + " technicians.", Username, true);
        }
        if (p.getFreeBays() < 0) {
            int numUnmaintained = p.setRandomUnmaintained();
            String toSend = "There are no longer enough technicians to maintain all of your equipment. ";
            toSend = numUnmaintained == 1 ? toSend + " 1 unit was pulled from the active rotation (A unit is" : toSend + numUnmaintained + " units were pulled from the active rotation (" + numUnmaintained + " units are ";
            toSend = toSend + " now unmaintained! Check your status!)";
            CampaignMain.cm.toUser(toSend, Username, true);
        }
    }

    private void fireAdvanceTechs(StringTokenizer command, String Username) {
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        int numberOfTechs = Integer.parseInt(command.nextToken());
        int techType = 0;
        if (command.hasMoreElements()) {
            techType = Integer.parseInt(command.nextToken());
        }
        int totalTechsToFire = player.getTotalTechs().elementAt(techType);
        int availableTechsToFire = player.getAvailableTechs().elementAt(techType);
        if (totalTechsToFire < numberOfTechs) {
            CampaignMain.cm.toUser("AM:You do not have enough " + UnitUtils.techDescription(techType) + " techs to fire! You only have " + totalTechsToFire + ".", Username, true);
            return;
        }
        if (availableTechsToFire < numberOfTechs) {
            CampaignMain.cm.toUser("AM:While you do have enough techs to fire some of them are currently working and you must wait for them to finish before you can fire them.", Username, true);
            return;
        }
        player.addAvailableTechs(techType, -numberOfTechs);
        player.addTotalTechs(techType, -numberOfTechs);
        if (numberOfTechs == 1) {
            CampaignMain.cm.toUser("AM:You have fired a " + UnitUtils.techDescription(techType) + " tech.", Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You have fired " + numberOfTechs + " " + UnitUtils.techDescription(techType) + " techs.", Username, true);
        }
    }
}

