/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class GamesCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        boolean factionSort = false;
        String factionName = "";
        if (command.hasMoreElements()) {
            try {
                factionName = command.nextToken().toLowerCase();
                if (factionName.trim().length() > 0) {
                    factionSort = true;
                }
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("AM:Games command failed. Check your input. It should be:/c games (to get all games) or /c games#faction (for a filtered list)", Username, true);
                return;
            }
        }
        String runningGames = "<h2>Running Games:</h2>";
        String finishedGames = "<br><h2>Finished Games:</h2>";
        int runningGamesCount = 0;
        TreeMap<Long, ShortOperation> timeSort = new TreeMap<Long, ShortOperation>();
        for (ShortOperation currO : CampaignMain.cm.getOpsManager().getRunningOps().values()) {
            if (factionSort && !currO.hasPlayerWhoseHouseBeginsWith(factionName)) continue;
            if (currO.getStatus() == ShortOperation.STATUS_FINISHED) {
                timeSort.put(currO.getCompletionTime(), currO);
                continue;
            }
            String currInfo = "";
            currInfo = currO.hasPlayerFrom(p.getMyHouse()) ? currInfo + "<br>" + currO.getInfo(true, false) : currInfo + "<br>" + currO.getInfo(false, false);
            runningGames = runningGames + currInfo;
            ++runningGamesCount;
        }
        if (runningGamesCount == 0) {
            runningGames = runningGames + "<br>- None";
        }
        if (timeSort.size() == 0) {
            finishedGames = finishedGames + "<br>- None";
        } else {
            for (ShortOperation currO : timeSort.values()) {
                finishedGames = finishedGames + "<br>" + currO.getInfo(true, false);
            }
        }
        CampaignMain.cm.toUser("SM|" + runningGames + finishedGames, Username, false);
    }
}

