/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class GetFactionConfigsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public String getSyntax() {
        return this.syntax;
    }

    public int getExecutionLevel() {
        return 0;
    }

    public void setExecutionLevel(int i) {
    }

    public void process(StringTokenizer command, String Username) {
        try {
            int userLevel;
            if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
                CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
                CampaignMain.cm.toUser("PL|FC|DONE#DONE", Username, false);
                return;
            }
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            String factionName = player.getMyHouse().getName();
            SHouse faction = null;
            long timeStamp = -1L;
            try {
                timeStamp = Long.parseLong(command.nextToken());
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("PL|FC|DONE#DONE", Username, false);
                return;
            }
            if (command.hasMoreElements()) {
                factionName = command.nextToken();
            }
            if ((faction = CampaignMain.cm.getHouseFromPartialString(factionName)) == null || faction.getConfig() == null) {
                CampaignMain.cm.toUser("PL|FC|DONE#DONE", Username, false);
                return;
            }
            if ((float)timeStamp >= faction.getLongConfig("TIMESTAMP")) {
                CampaignMain.cm.toUser("PL|FC|DONE#DONE", Username, false);
                return;
            }
            StringBuffer result = new StringBuffer("PL|FC|");
            String delimiter = "#";
            Enumeration<Object> keys = faction.getConfig().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = faction.getConfig(key);
                result.append(key);
                result.append(delimiter);
                result.append(value);
                result.append(delimiter);
            }
            result.append("DONE#DONE");
            CampaignMain.cm.toUser(result.toString(), Username, false);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("PL|FC|DONE#DONE", Username, false);
            CampaignData.mwlog.errLog(ex);
        }
    }
}

