/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.StringUtils;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class HireTechsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            this.hireAdvanceTechs(command, Username);
            return;
        }
        int numtohire = 1;
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int techCost = 0;
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:You are in a training faction, and may not hire techs until you join a normal faction.", Username, true);
            return;
        }
        try {
            numtohire = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:Hire command failed. Check your input. It should be something like this: /c hiretechs#3", Username, true);
            return;
        }
        techCost = p.getTechHiringFee();
        if ((techCost *= numtohire) > p.getMoney()) {
            CampaignMain.cm.toUser("AM:Hiring " + numtohire + " techs will cost you " + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ". You only have " + p.getMoney() + " " + CampaignMain.cm.moneyOrFluMessage(true, false, p.getMoney()) + ".", Username, true);
            return;
        }
        int maxTechs = Integer.parseInt(p.getMyHouse().getConfig("MaxTechsToHire"));
        if (maxTechs != -1 && p.getTechnicians() + numtohire > maxTechs) {
            CampaignMain.cm.toUser("AM:Sorry but the max number of technicians you can hire is " + maxTechs + ".", Username, true);
            return;
        }
        p.addTechnicians(numtohire);
        if (numtohire == 1) {
            CampaignMain.cm.toUser("AM:You've hired a technician! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ")", Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You've hired " + numtohire + " technicians! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ")", Username, true);
        }
        p.addMoney(-techCost);
    }

    private void hireAdvanceTechs(StringTokenizer command, String Username) {
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        int numberToHire = Integer.parseInt(command.nextToken());
        int techType = 0;
        int maxLevelTechHire = 1;
        if (!Boolean.parseBoolean(house.getConfig("AllowRegTechsToBeHired"))) {
            maxLevelTechHire = 0;
        }
        if (command.hasMoreElements()) {
            techType = Integer.parseInt(command.nextToken());
        }
        if (techType > maxLevelTechHire) {
            CampaignMain.cm.toUser("AM:Sorry there are no techs of that skill level on the market.", Username, true);
            return;
        }
        int hireCost = Integer.parseInt(house.getConfig(UnitUtils.techDescription(techType) + "TechHireCost"));
        if (player.getMoney() < (hireCost *= numberToHire)) {
            CampaignMain.cm.toUser("AM:Hiring " + numberToHire + " " + UnitUtils.techDescription(techType) + " techs will cost you " + CampaignMain.cm.moneyOrFluMessage(true, false, hireCost) + ". You only have " + player.getMoney() + " " + CampaignMain.cm.moneyOrFluMessage(true, false, player.getMoney()) + ".", Username, true);
            return;
        }
        player.addTotalTechs(techType, numberToHire);
        player.addAvailableTechs(techType, numberToHire);
        player.addMoney(-hireCost);
        if (numberToHire == 1) {
            CampaignMain.cm.toUser("AM:You've hired " + StringUtils.aOrAn(UnitUtils.techDescription(techType), true) + " technician! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, hireCost) + ")", Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You've hired " + numberToHire + " " + UnitUtils.techDescription(techType) + " technicians! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, hireCost) + ")", Username, true);
        }
    }
}

