/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.TechConstants;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;
import server.campaign.util.PlanetNameComparator;

public class HouseCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - void declaration
     */
    public void process(StringTokenizer command, String Username) {
        SPlanet currPlanet;
        int ownedWorldsSize;
        void var12_17;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreElements()) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c faction#name", Username, false);
            return;
        }
        String Name2 = (String)command.nextElement();
        SHouse h = (SHouse)CampaignMain.cm.getData().getHouseByName(Name2);
        if (h == null || h.getId() < 0) {
            CampaignMain.cm.toUser("AM:Could not find faction. Command fails.", Username, false);
            return;
        }
        String s = "<br><b><u>Status for: " + h.getColoredName() + "</u></b><br>";
        int totalOnline = h.getAllOnlinePlayers().size();
        int sinceLastRestart = h.getSmallPlayers().size();
        s = s + "Players: " + totalOnline + " online, " + sinceLastRestart + " logins since last restart.<br>";
        Vector<SPlanet> ownedWorlds = new Vector<SPlanet>(1, 1);
        Vector<SPlanet> contestedWorlds = new Vector<SPlanet>(1, 1);
        int totalOwnership = 0;
        for (SPlanet sPlanet : CampaignMain.cm.getData().getAllPlanets()) {
            int ownership = sPlanet.getInfluence().getInfluence(h.getId());
            totalOwnership += ownership;
            if (sPlanet.getOwner() != null && sPlanet.getOwner().equals(h)) {
                ownedWorlds.add(sPlanet);
                continue;
            }
            if (ownership <= 0) continue;
            contestedWorlds.add(sPlanet);
        }
        String string = "";
        int diff = totalOwnership - h.getInitialHouseRanking();
        if (diff > 0) {
            String string2 = string + "+" + diff;
        } else {
            String string3 = string + diff;
        }
        String string4 = (String)var12_17 + "/" + h.getInitialHouseRanking();
        s = s + "Ranking: " + string4 + "<br>";
        if (sinceLastRestart < 1) {
            sinceLastRestart = 1;
        }
        if ((ownedWorldsSize = ownedWorlds.size()) < 1) {
            ownedWorldsSize = 1;
        }
        s = s + "Total Economic Value: " + h.getComponentProduction() + "<br>" + "  - Avg. Planet: " + h.getComponentProduction() / ownedWorldsSize + "<br>" + "  - Per Capita: " + h.getComponentProduction() / sinceLastRestart + "<br><br>";
        s = s + "<br><b>Tech Level: </b>" + TechConstants.getLevelDisplayableName(h.getTechLevel()) + ".";
        if (CampaignMain.cm.getPlayer(Username).getMyHouse().equals(h) || CampaignMain.cm.getServer().isModerator(Username)) {
            s = s + " Current Research: " + h.getTechResearchPoints() + " of " + CampaignMain.cm.getConfig("TechPointsNeedToLevel");
        }
        s = s + "<br>";
        Collections.sort(ownedWorlds, new PlanetNameComparator());
        Collections.sort(contestedWorlds, new PlanetNameComparator());
        Iterator i = ownedWorlds.iterator();
        s = s + "<b>Planets (Owned):</b>";
        s = !i.hasNext() ? s + " none<br>" : s + "<br>";
        while (i.hasNext()) {
            int amtOwned;
            currPlanet = (SPlanet)i.next();
            s = s + currPlanet.getNameAsColoredLink();
            if (currPlanet.getFactoryCount() > 0) {
                s = s + "*";
            }
            if ((amtOwned = currPlanet.getInfluence().getInfluence(h.getId())) < currPlanet.getConquestPoints()) {
                s = s + " (" + amtOwned + "cp)";
            }
            if (i.hasNext()) {
                s = s + ", ";
                continue;
            }
            s = s + "<br>";
        }
        s = s + "<br><b>Planets (Contested):</b>";
        i = contestedWorlds.iterator();
        s = !i.hasNext() ? s + " none<br>" : s + "<br>";
        while (i.hasNext()) {
            SHouse owner;
            currPlanet = (SPlanet)i.next();
            s = s + currPlanet.getNameAsColoredLink();
            if (currPlanet.getFactoryCount() > 0) {
                s = s + "*";
            }
            s = (owner = currPlanet.getOwner()) != null ? s + " (" + currPlanet.getInfluence().getInfluence(h.getId()) + "cp, " + owner.getColoredAbbreviation(false) + " " + currPlanet.getInfluence().getInfluence(owner.getId()) + "cp)" : s + "(" + currPlanet.getInfluence().getInfluence(h.getId()) + "cp, No Owner)";
            if (i.hasNext()) {
                s = s + ", ";
                continue;
            }
            s = s + "<br>";
        }
        s = s + "<br><b>Current Games: </b>";
        String gameStrings = "";
        for (ShortOperation so : CampaignMain.cm.getOpsManager().getRunningOps().values()) {
            if (!so.hasPlayerWhoseHouseBeginsWith(h.getName())) continue;
            gameStrings = gameStrings + "<br>" + so.getInfo(false, false);
        }
        s = gameStrings.trim().equals("") ? s + "none.<br>" : s + gameStrings + "<br>";
        CampaignMain.cm.toUser("SM|" + s, Username, false);
    }
}

