/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.MercHouse;

public class HouseContractsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        StringBuilder toSend = new StringBuilder();
        int count = 0;
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        if (player.getMyHouse().isMercHouse()) {
            SHouse ourH = player.getMyHouse();
            toSend.append("Employed: <br>");
            for (SPlayer currP : ourH.getAllOnlinePlayers().values()) {
                if (ourH.getHouseFightingFor(currP).equals(ourH)) continue;
                toSend.append(currP.getName() + ": " + ourH.getHouseFightingFor(currP).getColoredName() + "<br>");
                ++count;
            }
            if (count == 0) {
                toSend.append("- NONE<br><br>");
            } else {
                toSend.append("<br>");
            }
            count = 0;
            toSend.append("Unemployed: <br>");
            for (SPlayer currP : ourH.getAllOnlinePlayers().values()) {
                if (!ourH.getHouseFightingFor(currP).equals(ourH)) continue;
                toSend.append(currP.getName() + ": " + ourH.getHouseFightingFor(currP).getColoredName() + "<br>");
                ++count;
            }
            if (count == 0) {
                toSend.append("- NONE<br>");
            }
            CampaignMain.cm.toUser(toSend.toString(), Username, true);
            return;
        }
        toSend.append("Mercenaries employed by your faction: <br>");
        Vector<MercHouse> mh = CampaignMain.cm.getMercHouses();
        for (MercHouse searchHouse : mh) {
            for (SPlayer currP : searchHouse.getAllOnlinePlayers().values()) {
                if (!searchHouse.getHouseFightingFor(currP).equals(player.getMyHouse())) continue;
                toSend.append(" - " + currP.getName() + "<br>");
                ++count;
            }
        }
        if (count == 0) {
            toSend.append("- NONE<br>");
        }
        CampaignMain.cm.toUser(toSend.toString(), Username, true);
    }
}

