/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;

public class JoinAttackCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        SPlayer ap;
        boolean minActiveMet;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        OperationManager manager = CampaignMain.cm.getOpsManager();
        SPlayer jp = CampaignMain.cm.getPlayer(Username);
        if (jp == null) {
            CampaignMain.cm.toUser("AM:Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        if (jp.getDutyStatus() < 3) {
            CampaignMain.cm.toUser("AM:You aren't on the front lines! (You are currently in Reserve. Activate in order to attack.)", Username, true);
            return;
        }
        if (jp.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        int altID = CampaignMain.cm.getOpsManager().playerIsAnAttacker(jp);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're only allowed to attack once, and are already in Attack #" + altID + ".", Username, true);
            return;
        }
        altID = CampaignMain.cm.getOpsManager().playerIsADefender(jp);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're already defending against Attack #" + altID + ".", Username, true);
            return;
        }
        boolean bl = minActiveMet = System.currentTimeMillis() - jp.getActiveSince() >= Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
        if (!minActiveMet) {
            CampaignMain.cm.toUser("AM:You're still on your way to the frontline. You cannot attack until you arrive.", Username, true);
            return;
        }
        try {
            ap = CampaignMain.cm.getPlayer(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Attacking Player not found.", Username, true);
            return;
        }
        ShortOperation o = manager.getShortOpForPlayer(ap);
        if (o == null) {
            CampaignMain.cm.toUser("AM:Short Operation not found for " + ap.getName() + ".", Username);
            return;
        }
        int armyID = -1;
        try {
            armyID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Non-number given for Army ID. Try again.", Username, true);
            return;
        }
        SArmy aa = ap.getArmy(armyID);
        if (aa == null) {
            CampaignMain.cm.toUser("AM:An error occured while creating your Army (The Army was null. This usually means the army doesn't exist. Example: you tried to use Army 1, but you only have Armies 0 and 2.)", Username, true);
            return;
        }
        if (aa.getBV() == 0) {
            CampaignMain.cm.toUser("AM:Army #" + armyID + " has a BV of 0 and may not be used to attack.", Username, true);
            return;
        }
        CampaignMain.cm.toUser("AM:" + o.checkTeam(ap.getTeamNumber(), aa.getBV(), true), Username);
        o.addAttacker(jp, aa, "");
        CampaignMain.cm.toUser("PL|STN|" + ap.getTeamNumber(), Username, false);
        CampaignMain.cm.toUser("AM:You have been assigned to team #" + ap.getTeamNumber(), Username);
        jp.setTeamNumber(ap.getTeamNumber());
    }
}

