/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class LinkUnitCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            SArmy a;
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int armyid = Integer.parseInt(command.nextToken());
            int slaveid = Integer.parseInt(command.nextToken());
            int masterid = -1;
            int linkid = -1;
            if (command.hasMoreElements()) {
                masterid = Integer.parseInt(command.nextToken());
            }
            if ((a = p.getArmy(armyid)) == null) {
                CampaignMain.cm.toUser("AM:Army #" + armyid + " does not exist.", Username, true);
                return;
            }
            if (a.isLocked()) {
                CampaignMain.cm.toUser("AM:You may not change C3 networks while an Army is in combat.", Username, true);
                return;
            }
            if (p.getDutyStatus() == 3) {
                CampaignMain.cm.toUser("AM:You may not change C3 networks while on active duty.", Username, true);
                return;
            }
            Unit slaveUnit = a.getUnit(slaveid);
            if (slaveUnit == null) {
                CampaignMain.cm.toUser("AM:Could not find unit #" + slaveid + " in army #" + armyid + ".", Username, true);
                return;
            }
            if (slaveUnit.hasBeenC3LinkedTo(a) && masterid == -1) {
                Enumeration<Integer> c3Key = a.getC3Network().keys();
                Enumeration<Integer> c3Unit = a.getC3Network().elements();
                while (c3Key.hasMoreElements()) {
                    Integer keyId = c3Key.nextElement();
                    Integer unitId = c3Unit.nextElement();
                    if (slaveUnit.getId() != unitId.intValue()) continue;
                    a.getC3Network().remove(keyId);
                }
                a.setRawForceSize(0.0f);
                a.setBV(0);
                String toReturn = "AM:Unit #" + slaveid + " was removed from its C3 network. New BV: " + a.getBV();
                CampaignMain.cm.toUser(toReturn, Username, true);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
                return;
            }
            if (masterid == -1) {
                a.getC3Network().remove(slaveid);
                a.setRawForceSize(0.0f);
                a.setBV(0);
                String toReturn = "AM:Unit #" + slaveid + " was removed from its C3 network. New BV: " + a.getBV();
                CampaignMain.cm.toUser(toReturn, Username, true);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
                return;
            }
            Unit masterUnit = a.getUnit(masterid);
            if (masterUnit == null) {
                CampaignMain.cm.toUser("AM:Unable to find master unit (#" + masterid + ") in Army #" + armyid + ".", Username, true);
                return;
            }
            linkid = slaveUnit.linkToC3Network(a, masterUnit);
            if (linkid == masterUnit.getId()) {
                a.setRawForceSize(0.0f);
                a.setBV(0);
                String toReturn = "AM:Unit #" + slaveUnit.getId() + " is now linked to Unit #" + masterUnit.getId() + ". New BV: " + a.getBV();
                CampaignMain.cm.toUser(toReturn, Username, true);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
            } else {
                CampaignMain.cm.toUser("AM:Unabled to Link Unit #" + slaveUnit.getId() + " to unit #" + masterUnit.getId() + ".", Username, true);
            }
        }
    }
}

