/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.House;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ListSubFactionCommand
implements Command {
    int accessLevel = 100;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String factionName = "";
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            factionName = command.hasMoreTokens() && CampaignMain.cm.getServer().isModerator(Username) ? command.nextToken() : player.getMyHouse().getName();
        }
        catch (Exception ex) {
            factionName = player.getMyHouse().getName();
        }
        if (factionName.equalsIgnoreCase("all")) {
            for (House faction : CampaignMain.cm.getData().getAllHouses()) {
                StringBuffer result = new StringBuffer("SM|Subfaction list for faction ");
                result.append(faction.getName());
                for (String subFactionName : faction.getSubFactionList().keySet()) {
                    result.append("<BR>");
                    result.append(subFactionName);
                }
                CampaignMain.cm.toUser(result.toString(), Username, false);
                result.setLength(0);
            }
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(factionName, Username);
        if (faction == null) {
            return;
        }
        StringBuffer result = new StringBuffer("SM|Subfaction list for faction ");
        result.append(faction.getName());
        for (String subFactionName : faction.getSubFactionList().keySet()) {
            result.append("<BR>");
            result.append(subFactionName);
        }
        CampaignMain.cm.toUser(result.toString(), Username, false);
    }
}

