/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.votes.Vote;
import server.campaign.votes.VoteManager;

public class MyVotesCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        Vote currVote;
        Enumeration<Vote> e;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean canVote = new Boolean(CampaignMain.cm.getConfig("VotingEnabled"));
        if (!canVote) {
            CampaignMain.cm.toUser("AM:Voting is disabled on this server.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        VoteManager vm = CampaignMain.cm.getVoteManager();
        Vector<Vote> posVotes = vm.getAllVotesBy(p, 1);
        Vector<Vote> negVotes = vm.getAllVotesBy(p, 2);
        String toPlayer = "Votes Cast: <br>-----------<br>";
        if (posVotes.size() == 0) {
            toPlayer = toPlayer + "- No positive votes cast.";
        } else {
            toPlayer = toPlayer + "Positive Votes Cast (" + posVotes.size() + "total):<br>";
            e = posVotes.elements();
            while (e.hasMoreElements()) {
                currVote = e.nextElement();
                toPlayer = toPlayer + currVote.getRecipient() + "<br>";
            }
            toPlayer = toPlayer + "<br>";
        }
        if (negVotes.size() == 0) {
            toPlayer = toPlayer + "- No negative votes cast.";
        } else {
            toPlayer = toPlayer + "Negative Votes Cast (" + negVotes.size() + "total):<br>";
            e = negVotes.elements();
            while (e.hasMoreElements()) {
                currVote = e.nextElement();
                toPlayer = toPlayer + "<br>" + currVote.getRecipient();
            }
        }
        Vector<Vote> absVotes = vm.getAllVotesBy(p, 0);
        int numAbs = absVotes.size();
        if (numAbs > 0) {
            toPlayer = toPlayer + "<br><br>NOTE: You have cast " + numAbs + "abstaining vote";
            if (numAbs > 1) {
                toPlayer = toPlayer + "s";
            }
            toPlayer = toPlayer + ". Votes to abstain have no effect. You should probably remove";
            toPlayer = numAbs > 1 ? toPlayer + " it." : toPlayer + " them.";
        }
        int votesCast = CampaignMain.cm.getVoteManager().getAllVotesBy(p).size();
        int votesAllowed = p.getNumberOfVotesAllowed();
        toPlayer = votesAllowed == votesCast ? toPlayer + "<br><br>NOTE: You have cast all of your votes (" + votesCast + "/" + votesAllowed + ")." : toPlayer + "<br><br>Votes Totals: " + votesCast + " votes cast. " + votesAllowed + " votes allowed " + votesCast + "/" + votesAllowed + ").<br>";
        CampaignMain.cm.toUser(toPlayer, Username, true);
    }
}

