/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.StringUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class NamePilotCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int unitid = -1;
        String name = "";
        try {
            unitid = Integer.parseInt((String)command.nextElement());
            name = (String)command.nextElement();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper syntx. Try: /c namepilot#unitid#newname", Username, true);
            return;
        }
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        if (StringUtils.hasBadChars(name, true).trim().length() > 0) {
            CampaignMain.cm.toUser(StringUtils.hasBadChars(name, true).trim(), Username);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null player while naming pilot. Report to an admin.", Username, true);
            return;
        }
        SUnit u = p.getUnit(unitid);
        if (u == null) {
            CampaignMain.cm.toUser("AM:Could not find a unit with ID#" + unitid + ".", Username, true);
            return;
        }
        SPilot pilot = (SPilot)u.getPilot();
        if (pilot == null) {
            CampaignMain.cm.toUser("AM:Unit #" + unitid + " has a null pilot. Report this to an admin.", Username, true);
            return;
        }
        if (pilot.getName().toLowerCase().startsWith("vacant")) {
            CampaignMain.cm.toUser("AM:There is no pilot in that unit! It is vacant!", Username, true);
            return;
        }
        pilot.setName(name);
        CampaignMain.cm.toUser("AM:The pilot of the " + u.getModelName() + " (#" + unitid + ") was renamed. New name: " + name + ".", Username, true);
        CampaignMain.cm.toUser("PL|UU|" + u.getId() + "|" + u.toString(true), Username, false);
    }
}

