/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.io.File;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.util.ExclusionList;

public class NoPlayCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        ExclusionList exList;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            return;
        }
        String mode = "";
        String excludeName = "";
        try {
            mode = command.nextToken().toLowerCase();
            excludeName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c noplay#add#name or /c noplay#remove#name.", Username, true);
            return;
        }
        boolean commandConfirmed = false;
        if (command.hasMoreElements()) {
            try {
                commandConfirmed = command.nextToken().equals("CONFIRM");
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("AM:Improper format. Try: /c noplay#add#name#CONFIRM or /c noplay#remove#name#CONFIRM", Username, true);
                return;
            }
        }
        if ((exList = p.getExclusionList()) == null) {
            CampaignMain.cm.toUser("AM:ERROR. Your no-play list was null. Report this to an admin.", Username, true);
            return;
        }
        int exclusionStatus = exList.checkExclude(excludeName);
        int maxSize = CampaignMain.cm.getIntegerConfig("NoPlayListSize");
        int removeRPCost = CampaignMain.cm.getIntegerConfig("NoPlayRPCost");
        int removeFluCost = CampaignMain.cm.getIntegerConfig("NoPlayInfluenceCost");
        int removeMUCost = CampaignMain.cm.getIntegerConfig("NoPlayMUCost");
        boolean adminListCountsForCap = new Boolean(CampaignMain.cm.getConfig("NoPlaysFromAdminsCountForMax"));
        boolean hasEnoughRP = false;
        boolean hasEnoughInfluence = false;
        boolean hasEnoughMU = false;
        if (p.getReward() >= removeRPCost) {
            hasEnoughRP = true;
        }
        if (p.getMoney() >= removeMUCost) {
            hasEnoughMU = true;
        }
        if (p.getInfluence() >= removeFluCost) {
            hasEnoughInfluence = true;
        }
        String costBlock = "";
        String shortCost = "";
        int totalVarsWithCost = 0;
        if (removeRPCost > 0) {
            ++totalVarsWithCost;
        }
        if (removeFluCost > 0) {
            ++totalVarsWithCost;
        }
        if (removeMUCost > 0) {
            ++totalVarsWithCost;
        }
        boolean canAffordRemove = false;
        if (hasEnoughRP && hasEnoughInfluence && hasEnoughMU) {
            costBlock = costBlock + " will ";
            canAffordRemove = true;
        } else {
            costBlock = costBlock + " would ";
        }
        costBlock = costBlock + " cost ";
        if (removeRPCost > 0) {
            shortCost = shortCost + removeRPCost + " RP";
            if (totalVarsWithCost == 3) {
                shortCost = shortCost + ", ";
            } else if (totalVarsWithCost == 2) {
                shortCost = shortCost + " and ";
            }
        }
        if (removeMUCost > 0) {
            shortCost = shortCost + CampaignMain.cm.moneyOrFluMessage(true, true, removeMUCost) + "";
            if (totalVarsWithCost == 3) {
                shortCost = shortCost + " and ";
            } else if (totalVarsWithCost == 2 && removeRPCost <= 0) {
                shortCost = shortCost + " and ";
            }
        }
        if (removeFluCost > 0) {
            shortCost = shortCost + CampaignMain.cm.moneyOrFluMessage(false, true, removeFluCost) + "";
        }
        costBlock = costBlock + shortCost + ".";
        if (mode.equals("add")) {
            boolean playerExists = false;
            playerExists = !CampaignMain.cm.isUsingMySQL() ? new File("./campaign/players/" + excludeName.toLowerCase() + ".dat").exists() : CampaignMain.cm.MySQL.playerExists(excludeName);
            if (!playerExists) {
                CampaignMain.cm.toUser(excludeName + " does not have a player file. cannot add to your no-play list.", Username, true);
                return;
            }
            if (exclusionStatus != 0) {
                CampaignMain.cm.toUser(excludeName + " is already on your no-play list.", Username, true);
                return;
            }
            if (p.getName().toLowerCase().equals(excludeName)) {
                CampaignMain.cm.toUser("AM:You can't put your own name on your no-play list. Jackass.", Username, true);
                return;
            }
            if (adminListCountsForCap && exList.getAdminExcludes().size() >= maxSize) {
                CampaignMain.cm.toUser("AM:Moderators/Admins have filled your no-play list. You may not add any players on your own at this time.", Username, true);
                return;
            }
            int currentSize = exList.getPlayerExcludes().size();
            if (adminListCountsForCap) {
                currentSize += exList.getAdminExcludes().size();
            }
            if (currentSize >= maxSize && exList.getPlayerExcludes().size() > 0) {
                if (canAffordRemove) {
                    String toUser = "AM:You must remove a player from your no-play list in order to add " + excludeName + ". Removing " + costBlock + "<br>";
                    for (String currName : exList.getPlayerExcludes()) {
                        toUser = toUser + "<a href=\"MEKWARS/c removeandaddnoplay#" + currName + "#" + excludeName + "\">Click here to remove " + currName + " and add " + excludeName + "</a>.<br>";
                    }
                    CampaignMain.cm.toUser(toUser, Username, true);
                    return;
                }
                String toUser = "AM:You must remove a player from your no-play list before adding " + excludeName + "; however, you cannot " + "afford a removal at this time. Removing costs " + shortCost + ".<br>";
                CampaignMain.cm.toUser(toUser, Username, true);
                return;
            }
            if (commandConfirmed) {
                try {
                    exList.addExclude(false, excludeName);
                    CampaignMain.cm.toUser(excludeName + " was added to your no-play list.", Username, true);
                    CampaignMain.cm.toUser("PL|PEU|" + p.getExclusionList().playerExcludeToString("$"), Username, false);
                    p.setSave();
                    return;
                }
                catch (Exception e) {
                    CampaignMain.cm.toUser("AM:Error while adding " + excludeName + " to your no-play list. Report this to an admin.", Username, true);
                    return;
                }
            }
            String toUser = "AM:Are you sure you want to add " + excludeName + " to your no-play list? <br><a " + "href=\"MEKWARS/c noplay#add#" + excludeName + "#CONFIRM\">Click here to confirm the addition " + "of " + excludeName + " to your no-play list</a>.<br>";
            CampaignMain.cm.toUser(toUser, Username, true);
            return;
        }
        if (mode.equals("remove")) {
            if (exclusionStatus == 0) {
                CampaignMain.cm.toUser(excludeName + " is not on your no-play list.", Username, true);
                return;
            }
            if (exclusionStatus == 2) {
                CampaignMain.cm.toUser("AM:You cannot remove " + excludeName + " from your no-play list. He/she " + "was added to the list by a Mod or Admin.", Username, true);
                return;
            }
            if (!canAffordRemove) {
                String toUser = "AM:You cannot afford to remove " + excludeName + " from your no-play list. Removal " + costBlock;
                CampaignMain.cm.toUser(toUser, Username, true);
                return;
            }
            if (commandConfirmed) {
                try {
                    exList.removeExclude(false, excludeName);
                    CampaignMain.cm.toUser(excludeName + "was removed from your no-play list (-" + shortCost + ").", Username, true);
                    p.addMoney(-removeMUCost);
                    p.addReward(-removeRPCost);
                    p.addInfluence(-removeFluCost);
                    CampaignMain.cm.toUser("PL|PEU|" + p.getExclusionList().playerExcludeToString("$"), Username, false);
                    p.setSave();
                    return;
                }
                catch (Exception e) {
                    CampaignMain.cm.toUser("AM:Error while removing " + excludeName + " from your no-play list. Report this to an admin.", Username, true);
                    return;
                }
            }
            String toUser = "AM:Are you sure you want to remove " + excludeName + " from your no-play list? Removal " + costBlock + "<br><a " + "href=\"MEKWARS/c noplay#remove#" + excludeName + "#CONFIRM\">Click here to confirm the removal</a>.<br>";
            CampaignMain.cm.toUser(toUser, Username, true);
            return;
        }
        CampaignMain.cm.toUser("AM:Improper format. Try: /c noplay#add#name or /c noplay#remove#name.", Username, true);
    }
}

