/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class OfferContractCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String strContractType;
        int contractDuration;
        int contractPayment;
        String receivingPlayerName;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            receivingPlayerName = command.nextToken();
            contractPayment = Integer.parseInt(command.nextToken());
            contractDuration = Integer.parseInt(command.nextToken());
            strContractType = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid Syntax: /offercontract Merc Name#ContractPayment#ContarctDuration#Contract Type[land,units,components,delay,exp]", Username);
            return;
        }
        int contractType = ContractInfo.getContractType(strContractType);
        SPlayer offeringPlayer = CampaignMain.cm.getPlayer(Username);
        SPlayer receivingPlayer = CampaignMain.cm.getPlayer(receivingPlayerName);
        if (receivingPlayer == null) {
            CampaignMain.cm.toUser("AM:There's no such player", Username, true);
            return;
        }
        if (receivingPlayer.getMyHouse().isMercHouse()) {
            boolean noOtherOffers = true;
            int minContract = CampaignMain.cm.getIntegerConfig("MinContractEXP");
            if (contractType == 4 || contractType == 1 || contractType == 2) {
                minContract /= 10;
            }
            for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
                ContractInfo info = CampaignMain.cm.getUnresolvedContracts().get(i);
                if (info.getOfferingPlayer() != offeringPlayer) continue;
                noOtherOffers = false;
            }
            if (contractPayment < 2) {
                CampaignMain.cm.toUser("AM:You must pay a mercenary at least " + CampaignMain.cm.moneyOrFluMessage(true, true, 2) + ".", Username, true);
            } else if (contractDuration < minContract) {
                CampaignMain.cm.toUser("AM:Mercenaries must do work to get paid. Set a contract term of at least " + minContract + " " + strContractType, Username, true);
            } else if (!noOtherOffers) {
                CampaignMain.cm.toUser("AM:You may offer only one contract at a time.", Username, true);
            } else if (offeringPlayer.getMoney() < contractPayment) {
                CampaignMain.cm.toUser("AM:Your offer exceeds your monetary resources. Get loans or lower your offer.", Username, true);
            } else if (offeringPlayer.getMyHouse().isNewbieHouse()) {
                CampaignMain.cm.toUser("AM:No Mercenary would ever fight for SOL!", Username, true);
            } else if (offeringPlayer.getMyHouse().isMercHouse()) {
                CampaignMain.cm.toUser("AM:Mercenaries may not employ other mercenaries", Username, true);
            } else if (!receivingPlayer.getMyHouse().isLoggedIntoFaction(receivingPlayerName)) {
                CampaignMain.cm.toUser("AM:You may only offer contracts to players currently online", Username, true);
            } else if (((MercHouse)receivingPlayer.getMyHouse()).getContractInfo(receivingPlayer) != null) {
                CampaignMain.cm.toUser("AM:You may not offer contracts to mercenaries with employers", Username, true);
            } else {
                CampaignMain.cm.toUser(offeringPlayer.getName() + " of " + offeringPlayer.getMyHouse().getName() + " has offered you " + CampaignMain.cm.moneyOrFluMessage(true, false, contractPayment) + " for " + contractDuration + " " + strContractType + " of service.", receivingPlayerName, true);
                CampaignMain.cm.toUser("AM:You have offered " + receivingPlayerName + " " + CampaignMain.cm.moneyOrFluMessage(true, false, contractPayment) + " for " + contractDuration + " " + strContractType + " of service.", Username, true);
                ContractInfo newContract = new ContractInfo(contractDuration, contractPayment, offeringPlayer.getMyHouse(), receivingPlayerName, contractType);
                newContract.setOfferingPlayer(offeringPlayer);
                CampaignMain.cm.getUnresolvedContracts().add(newContract);
                CampaignMain.cm.getUnresolvedContracts().trimToSize();
                CampaignMain.cm.toUser("AM:Accept this contract by <a href=\"MEKWARS/c acceptcontract#" + offeringPlayer.getName() + "\">clicking here</a>", receivingPlayerName, true);
                CampaignMain.cm.toUser("AM:Decline this contract by <a href=\"MEKWARS/c refusecontract#" + offeringPlayer.getName() + "\">clicking here</a>", receivingPlayerName, true);
                CampaignMain.cm.toUser("AM:Cancel this offer by <a href=\"MEKWARS/c canceloffer\">clicking here</a>", Username, true);
            }
        } else {
            CampaignMain.cm.toUser("AM:You may not offer contracts to non-mercenary players.", Username, true);
        }
    }
}

