/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.House;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class PlayersCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        TreeMap<String, SPlayer> sortedPlayers;
        SHouse h;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String toSend = "";
        toSend = toSend + "<br><h2>Fighting Players:</h2><br>";
        for (House vh : CampaignMain.cm.getData().getAllHouses()) {
            h = (SHouse)vh;
            if (h.getFightingPlayers().size() <= 0) continue;
            sortedPlayers = new TreeMap<String, SPlayer>();
            sortedPlayers.putAll(h.getFightingPlayers());
            toSend = toSend + "<b>" + h.getColoredNameAsLink() + ":</b> ";
            for (SPlayer currP : sortedPlayers.values()) {
                toSend = toSend + currP.getName() + ", ";
            }
            toSend = toSend.substring(0, toSend.length() - 2) + "<br>";
        }
        if (!new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")).booleanValue()) {
            toSend = toSend + "<br><h2>Active Duty Players:</h2><br>";
            for (House vh : CampaignMain.cm.getData().getAllHouses()) {
                h = (SHouse)vh;
                if (h.getActivePlayers().size() <= 0) continue;
                sortedPlayers = new TreeMap();
                sortedPlayers.putAll(h.getActivePlayers());
                toSend = toSend + "<b>" + h.getColoredNameAsLink() + ":</b> ";
                for (SPlayer currP : sortedPlayers.values()) {
                    toSend = toSend + currP.getName() + ", ";
                }
                toSend = toSend.substring(0, toSend.length() - 2) + "<br>";
            }
            toSend = toSend + "<br><h2>Reserve Duty Players:</h2><br>";
            for (House vh : CampaignMain.cm.getData().getAllHouses()) {
                h = (SHouse)vh;
                if (h.getReservePlayers().size() <= 0) continue;
                sortedPlayers = new TreeMap();
                sortedPlayers.putAll(h.getReservePlayers());
                toSend = toSend + "<b>" + h.getColoredNameAsLink() + ":</b> ";
                for (SPlayer currP : sortedPlayers.values()) {
                    if (currP.isInvisible()) continue;
                    toSend = toSend + currP.getName() + ", ";
                }
                toSend = toSend.substring(0, toSend.length() - 2) + "<br>";
            }
        } else {
            toSend = toSend + "<br><h2>Online Players (Not Fighting):</h2><br>";
            for (House vh : CampaignMain.cm.getData().getAllHouses()) {
                SHouse h2 = (SHouse)vh;
                TreeMap<String, SPlayer> combinedTable = new TreeMap<String, SPlayer>();
                combinedTable.putAll(h2.getReservePlayers());
                combinedTable.putAll(h2.getActivePlayers());
                boolean playersFaction = h2.equals(CampaignMain.cm.getPlayer(Username).getMyHouse());
                boolean isAdmin = CampaignMain.cm.getServer().isAdmin(Username);
                if (combinedTable.size() <= 0) continue;
                toSend = toSend + "<b>" + h2.getColoredNameAsLink() + ":</b> ";
                for (SPlayer currP : combinedTable.values()) {
                    if (currP.isInvisible()) continue;
                    if ((playersFaction || isAdmin) && currP.getDutyStatus() == 3) {
                        toSend = toSend + "<i>" + currP.getName() + "</i>, ";
                        continue;
                    }
                    toSend = toSend + currP.getName() + ", ";
                }
                toSend = toSend.substring(0, toSend.length() - 2);
                if (isAdmin || playersFaction) {
                    toSend = toSend + " (Active: " + h2.getActivePlayers().size() + ")<br>";
                    continue;
                }
                toSend = toSend + "<br>";
            }
        }
        CampaignMain.cm.toUser("SM|" + toSend, Username, false);
    }
}

