/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.AstechSkill;
import server.campaign.pilot.skills.EdgeSkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;

public class PromotePilotCommand
implements Command {
    int accessLevel = 0;
    String syntax = "promotepilot#unitid#skill";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(StringTokenizer command, String Username) {
        String skill;
        SUnit unit;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        int cost = 0;
        SPilotSkill ps = null;
        if (!CampaignMain.cm.getBooleanConfig("PlayersCanBuyPilotUpgrades")) {
            return;
        }
        try {
            unit = player.getUnit(Integer.parseInt(command.nextToken()));
            skill = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c " + this.syntax, Username);
            return;
        }
        if (unit == null) {
            CampaignMain.cm.toUser("AM:Cannot find that unit!", Username);
            return;
        }
        if (unit.hasVacantPilot()) {
            CampaignMain.cm.toUser("AM:Unit " + unit.getModelName() + " has no pilot to promote!", Username);
            return;
        }
        SPilot pilot = (SPilot)unit.getPilot();
        if (skill.trim().length() < 1) {
            CampaignMain.cm.toUser("AM:A skill needs to be provided", Username, true);
            return;
        }
        if (skill.equalsIgnoreCase("gunnery")) {
            int gun = pilot.getGunnery();
            int piloting = pilot.getPiloting();
            if (pilot.getSkills().has(5)) {
                ++gun;
            }
            if (pilot.getSkills().has(6)) {
                ++piloting;
            }
            if (piloting - (gun - 1) > 1 && CampaignMain.cm.getBooleanConfig("PilotsMustLevelEvenly")) {
                CampaignMain.cm.toUser("AM:You must evenly level your pilots skills. Try leveling piloting first.", Username);
                return;
            }
            int totalSkill = Math.min(9, gun + piloting);
            cost = CampaignMain.cm.getIntegerConfig("BaseRollToLevel");
            cost *= CampaignMain.cm.getIntegerConfig("MultiplierPerPreviousLevel");
            cost *= 10 - totalSkill;
        } else if (skill.equalsIgnoreCase("piloting")) {
            int gun = pilot.getGunnery();
            int piloting = pilot.getPiloting();
            if (pilot.getSkills().has(5)) {
                ++gun;
            }
            if (pilot.getSkills().has(6)) {
                ++piloting;
            }
            if (gun - (piloting - 1) > 1 && CampaignMain.cm.getBooleanConfig("PilotsMustLevelEvenly")) {
                CampaignMain.cm.toUser("AM:You must evenly level your pilots skills. Try leveling gunnery first.", Username);
                return;
            }
            int totalSkill = Math.min(9, gun + piloting);
            cost = CampaignMain.cm.getIntegerConfig("BaseRollToLevel");
            cost *= CampaignMain.cm.getIntegerConfig("MultiplierPerPreviousLevel");
            cost *= 10 - totalSkill;
        } else {
            ps = CampaignMain.cm.getPilotSkill(skill);
            skill = ps.getName();
            if (pilot.getSkills().has(ps.getId()) && pilot.getSkills().getPilotSkill(ps.getId()).getLevel() >= 0) {
                if (ps.getId() == 2) {
                    ps = (SPilotSkill)pilot.getSkills().getPilotSkill(2);
                    if (ps.getLevel() >= 2) {
                        CampaignMain.cm.toUser("AM:You cannot raise your pilots AstechSkill any higher!", Username);
                        return;
                    }
                    cost = CampaignMain.cm.getIntegerConfig("chancefor" + ps.getAbbreviation() + "for" + SUnit.getTypeClassDesc(unit.getType()));
                    cost *= ps.getLevel() + 2;
                } else {
                    if (ps.getId() != 20) {
                        CampaignMain.cm.toUser("AM:Your pilot already has that skill!", Username);
                        return;
                    }
                    ps = (SPilotSkill)pilot.getSkills().getPilotSkill(20);
                    if (ps.getLevel() >= CampaignMain.cm.getIntegerConfig("MaxEdgeChanges")) {
                        CampaignMain.cm.toUser("AM:You cannot raise your pilots Edge any higher!", Username);
                        return;
                    }
                    cost = CampaignMain.cm.getIntegerConfig("chancefor" + ps.getAbbreviation() + "for" + SUnit.getTypeClassDesc(unit.getType()));
                    cost *= ps.getLevel() + 1;
                }
            } else {
                cost = CampaignMain.cm.getIntegerConfig("chancefor" + ps.getAbbreviation() + "for" + SUnit.getTypeClassDesc(unit.getType()));
            }
        }
        if (pilot.getSkills().has(18)) {
            cost = (int)((double)cost * (1.0 - CampaignMain.cm.getDoubleConfig("GiftedPercent")));
        }
        if (pilot.getExperience() < cost) {
            CampaignMain.cm.toUser("AM:" + pilot.getName() + " does not have enough experience to purchase that skill", Username);
            return;
        }
        if (skill.equalsIgnoreCase("gunnery")) {
            pilot.setGunnery(pilot.getGunnery() - 1);
        } else if (skill.equalsIgnoreCase("piloting")) {
            pilot.setPiloting(pilot.getPiloting() - 1);
        } else {
            if (ps instanceof WeaponSpecialistSkill) {
                ((WeaponSpecialistSkill)ps).assignWeapon(unit.getEntity(), pilot);
            } else if (ps instanceof TraitSkill) {
                ((TraitSkill)ps).assignTrait(pilot);
            } else if (ps instanceof EdgeSkill) {
                if (pilot.getSkills().has(ps)) {
                    ((EdgeSkill)ps).setLevel(ps.getLevel() + 1);
                }
            } else if (ps instanceof AstechSkill && pilot.getSkills().has(ps)) {
                ((AstechSkill)ps).setLevel(ps.getLevel() + 1);
            }
            ps.addToPilot(pilot);
            ps.modifyPilot(pilot);
        }
        pilot.setExperience(pilot.getExperience() - cost);
        unit.setPilot(pilot);
        CampaignMain.cm.toUser("AM:Skill " + skill + " purchased for pilot " + pilot.getName() + " for " + cost + " exp.", Username);
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
    }
}

