/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RangeCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            String target;
            int range = Integer.parseInt(command.nextToken());
            SHouse targetfaction = null;
            if (command.hasMoreElements() && (targetfaction = CampaignMain.cm.getHouseFromPartialString(target = command.nextToken(), Username)) == null) {
                CampaignMain.cm.toUser("AM:Could not find faction " + target + ". Try again?", Username, true);
                return;
            }
            boolean facWorldsOnly = false;
            if (command.hasMoreElements()) {
                try {
                    facWorldsOnly = Boolean.parseBoolean(command.nextToken());
                }
                catch (Exception e) {
                    CampaignMain.cm.toUser("AM:Improper format. Try: /c range#Distance#Faction#true to return only production worlds.", Username, true);
                    return;
                }
            }
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SHouse h = player.getMyHouse();
            String result = "These planets are within " + range + " light-years ";
            if (targetfaction != null) {
                result = facWorldsOnly ? result + "and " + targetfaction.getName() + " production facilities are present " : result + "and " + targetfaction.getName() + " military assets are present ";
            }
            result = result + ":<br>";
            for (SPlanet sPlanet : CampaignMain.cm.getData().getAllPlanets()) {
                SHouse owner;
                if (h.getDistanceTo(sPlanet, CampaignMain.cm.getPlayer(Username)) > range) continue;
                if (targetfaction == null) {
                    owner = sPlanet.getOwner();
                    if (facWorldsOnly && owner.equals(targetfaction) && sPlanet.getFactoryCount() > 0) {
                        result = result + "<font color=\"" + sPlanet.getOwner().getHouseColor() + "\">" + sPlanet.getShortDescription(true) + "</font>" + "<br>";
                        continue;
                    }
                    if (owner != null) {
                        result = result + "<font color=\"" + sPlanet.getOwner().getHouseColor() + "\">" + sPlanet.getShortDescription(true) + "</font>" + "<br>";
                        continue;
                    }
                    result = result + sPlanet.getSmallStatus(true) + "<br>";
                    continue;
                }
                if (sPlanet.getInfluence().getInfluence(targetfaction.getId()) <= 0) continue;
                owner = sPlanet.getOwner();
                if (owner != null) {
                    result = result + "<font color=\"" + sPlanet.getOwner().getHouseColor() + "\">" + sPlanet.getShortDescription(true) + "</font>" + "<br>";
                    continue;
                }
                result = result + sPlanet.getSmallStatus(true) + "<br>";
            }
            result = result.substring(0, result.length() - 2);
            CampaignMain.cm.toUser("SM|" + result, Username, false);
        }
    }
}

