/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class RefreshFactoryCommand
implements Command {
    int accessLevel = 1;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String factoryName;
        String planetName;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.getBooleanConfig("AllowFactoryRefreshForRewards")) {
            CampaignMain.cm.toUser("AM:You may not use RP to refresh a factory on this server.", Username, true);
            return;
        }
        int rpCost = CampaignMain.cm.getIntegerConfig("RewardPointToRefreshFactory");
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            planetName = command.nextToken();
            factoryName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c refreshfactory#planetname#factoryname", Username, true);
            return;
        }
        SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(planetName);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Could not find planet: " + planetName + ".", Username, true);
            return;
        }
        SUnitFactory uf = (SUnitFactory)CampaignMain.cm.getData().getFactoryByName(p, factoryName);
        if (uf == null) {
            CampaignMain.cm.toUser("AM:Could not find factory: " + factoryName + ".", Username, true);
            return;
        }
        int playerRP = player.getReward();
        if (playerRP < rpCost) {
            CampaignMain.cm.toUser(rpCost + " reward points required to refresh " + uf.getName() + ". You only have " + playerRP + ".", Username, true);
            return;
        }
        player.addReward(-rpCost);
        int ticksToRemove = uf.getTicksUntilRefresh();
        String refresh = uf.addRefresh(-ticksToRemove, true);
        CampaignMain.cm.doSendToAllOnlinePlayers(player.getMyHouse(), "HS|" + refresh, false);
        CampaignMain.cm.toUser("AM:You refreshed " + uf.getName() + " on planet " + p.getName() + " (-" + rpCost + " RP).", Username, true);
        CampaignMain.cm.doSendHouseMail(player.getMyHouse(), "NOTE", player.getName() + " refreshed " + uf.getName() + " on planet " + p.getName());
    }
}

