/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;

public class RefuseContractCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean contractCancelled = false;
        String receivingPlayerName = "";
        boolean offeringPlayerFound = false;
        String offeringPlayerName = command.nextToken();
        for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
            ContractInfo info = CampaignMain.cm.getUnresolvedContracts().get(i);
            if (!info.getOfferingPlayerName().equalsIgnoreCase(offeringPlayerName)) continue;
            offeringPlayerFound = true;
            receivingPlayerName = info.getPlayerName();
            if (CampaignMain.cm.getPlayer(receivingPlayerName) != CampaignMain.cm.getPlayer(Username)) continue;
            CampaignMain.cm.getUnresolvedContracts().remove(i);
            contractCancelled = true;
            CampaignMain.cm.toUser("AM:You refused the contract offered by " + offeringPlayerName, Username, true);
            CampaignMain.cm.toUser(Username + " refused your contract offer", offeringPlayerName, true);
            CampaignMain.cm.getUnresolvedContracts().trimToSize();
            break;
        }
        if (!contractCancelled) {
            if (!offeringPlayerFound) {
                CampaignMain.cm.toUser("AM:This player has no outstanding contracts", Username, true);
            } else {
                CampaignMain.cm.toUser("AM:This player has not offered you a contract.", Username, true);
            }
        }
    }
}

