/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.util.MWPasswd;

public class RegisterCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        if (CampaignMain.cm.getPlayer(Username) == null) {
            CampaignMain.cm.toUser("<font color=\"navy\"><br>---<br>You must have a campaign account in order to register a nickname. [<a href=\"MEKWARS/c enroll\">Click to get started</a>]<br>---<br></font>", Username, true);
            return;
        }
        try {
            StringTokenizer str = new StringTokenizer(command.nextToken(), ",");
            String regname = "";
            String pw = "";
            String email = "";
            SPlayer player = null;
            try {
                regname = str.nextToken().trim().toLowerCase();
                if (CampaignMain.cm.requireEmailForRegistration()) {
                    email = str.nextToken();
                }
                pw = str.nextToken();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Failure to register: " + regname);
                return;
            }
            boolean regged = false;
            try {
                player = CampaignMain.cm.getPlayer(regname);
                if (player.getPassword() != null && player.getPassword().access >= 2) {
                    regged = true;
                }
            }
            catch (Exception ex) {
                regged = true;
            }
            if (regged && !CampaignMain.cm.getServer().isAdmin(Username)) {
                CampaignMain.cm.toUser("AM:Nickname \"" + regname + "\" is already registered!", Username);
                CampaignMain.cm.doSendModMail("NOTE", Username + " tried to register the nickname \"" + regname + "\", which was already registered.");
                return;
            }
            if (pw.length() < 3 && pw.length() > 11) {
                CampaignMain.cm.toUser("AM:Passwords must be between 4 and 10 characters!", Username);
                return;
            }
            if (CampaignMain.cm.isSynchingBB() && !CampaignMain.cm.MySQL.addUserToForum(Username, pw, email)) {
                return;
            }
            int level = -1;
            if (CampaignMain.cm.getServer().isAdmin(Username)) {
                MWPasswd.writeRecord(regname, 200, pw);
                level = 200;
            } else {
                MWPasswd.writeRecord(regname, 2, pw);
                level = 2;
            }
            CampaignMain.cm.getServer().getClient(regname).setAccessLevel(level);
            CampaignMain.cm.getServer().getUser(regname).setLevel(level);
            CampaignMain.cm.getServer().sendRemoveUserToAll(regname, false);
            CampaignMain.cm.getServer().sendNewUserToAll(regname, false);
            if (player != null) {
                CampaignMain.cm.doSendToAllOnlinePlayers("PI|DA|" + CampaignMain.cm.getPlayerUpdateString(player), false);
            }
            if (CampaignMain.cm.isUsingMySQL() && player != null) {
                CampaignMain.cm.MySQL.setPlayerPassword(CampaignMain.cm.MySQL.getPlayerIDByName(Username), pw);
                CampaignMain.cm.MySQL.setPlayerAccess(CampaignMain.cm.MySQL.getPlayerIDByName(Username), level);
                if (CampaignMain.cm.isSynchingBB()) {
                    player.setForumID(CampaignMain.cm.MySQL.getUserForumID(Username, email));
                    CampaignMain.cm.MySQL.addUserToHouseForum(player.getForumID(), player.getMyHouse().getForumID());
                }
            }
            CampaignMain.cm.toUser("AM:\"" + regname + "\" successfully registered.", Username);
            CampaignData.mwlog.modLog("New nickname registered: " + regname);
            CampaignMain.cm.doSendModMail("NOTE", "New nickname registered: " + regname + " by: " + Username);
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
            CampaignData.mwlog.errLog("^ Not supposed to happen! ^");
            CampaignData.mwlog.errLog(e);
            CampaignData.mwlog.errLog("Not supposed to happen");
        }
    }
}

