/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class ReloadAllAmmoCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int unitid = 0;
        try {
            unitid = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:ReloadAllAmmo command failed. Check your input. It should be something like this: /c reloadAllAmmo#unitid", Username, true);
            return;
        }
        SUnit unit = p.getUnit(unitid);
        Entity en = unit.getEntity();
        int cost = 0;
        int refillShots = 0;
        double ammoCharge = 0.0;
        if (!CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            AmmoType baseAmmo;
            for (Mounted ammo : en.getAmmo()) {
                baseAmmo = (AmmoType)ammo.getType();
                refillShots = baseAmmo.getShots();
                ammoCharge = CampaignMain.cm.getAmmoCost(baseAmmo.getInternalName());
                if (ammoCharge < 0.0) continue;
                if (ammo.getLocation() == -1) {
                    refillShots = 1;
                } else {
                    if (refillShots == ammo.getShotsLeft()) continue;
                    refillShots -= ammo.getShotsLeft();
                }
                cost = (int)((double)cost + (ammoCharge *= (double)refillShots));
            }
            if (cost > p.getMoney()) {
                CampaignMain.cm.toUser("AM:You do not have enough to fully reload Unit #" + unit.getId() + ". It would cost " + CampaignMain.cm.moneyOrFluMessage(true, false, cost), Username);
                return;
            }
            for (Mounted ammo : en.getAmmo()) {
                baseAmmo = (AmmoType)ammo.getType();
                ammoCharge = CampaignMain.cm.getAmmoCost(baseAmmo.getInternalName());
                if (ammoCharge < 0.0) continue;
                refillShots = baseAmmo.getShots();
                if (ammo.getLocation() == -1) {
                    refillShots = 1;
                } else if (baseAmmo.getAmmoType() == 29) {
                    refillShots = 1;
                }
                ammo.setShotsLeft(refillShots);
            }
        } else {
            for (Mounted ammo : en.getAmmo()) {
                AmmoType baseAmmo = (AmmoType)ammo.getType();
                refillShots = baseAmmo.getShots();
                int ammoAmount = 0;
                if ((ammo.getLocation() == -1 || baseAmmo.getAmmoType() == 29) && ammo.getShotsLeft() != 1) {
                    ammoAmount = 1;
                    refillShots = 1;
                } else {
                    if (refillShots == ammo.getShotsLeft()) continue;
                    ammoAmount = refillShots - ammo.getShotsLeft();
                    if (p.getPartsAmount(baseAmmo.getInternalName()) < ammoAmount) {
                        if (p.getAutoReorder()) {
                            String newCommand = baseAmmo.getInternalName() + "#" + ammoAmount;
                            CampaignMain.cm.getServerCommands().get("BUYPARTS").process(new StringTokenizer(newCommand, "#"), Username);
                        }
                        ammoAmount = p.getPartsAmount(baseAmmo.getInternalName());
                    }
                    refillShots = ammoAmount + ammo.getShotsLeft();
                }
                p.updatePartsCache(baseAmmo.getInternalName(), -ammoAmount);
                ammo.setShotsLeft(refillShots);
            }
        }
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
        p.addMoney(-cost);
        CampaignMain.cm.toUser("AM:Ammo set for " + unit.getModelName() + " (#" + unit.getId() + ") at a cost of " + CampaignMain.cm.moneyOrFluMessage(true, false, cost), Username, true);
    }
}

