/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RemoveArmyCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null player while removing army. Report this to an admin. Remove fails.", Username, true);
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper usage. Try: /c removearmy#ID", Username, true);
            return;
        }
        SArmy toRemove = p.getArmy(id);
        if (toRemove == null) {
            CampaignMain.cm.toUser("AM:No army with that ID. Remove failed.", Username, true);
            return;
        }
        if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
            CampaignMain.cm.toUser("AM:You may not modify your armies while in a game.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 3 && toRemove.getAmountOfUnits() != 0) {
            CampaignMain.cm.toUser("AM:You may not modify armies while active.", Username, true);
            return;
        }
        p.removeArmy(id);
        p.resetWeightedArmyNumber();
        CampaignMain.cm.toUser("AM:Army #" + id + " was removed.", Username, true);
    }
}

