/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.votes.Vote;

public class RemoveVoteCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer castingPlayer = CampaignMain.cm.getPlayer(Username);
        String recipientName = "";
        try {
            recipientName = new String(command.nextToken()).toString();
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:RemoveVote command failed. Check your input. It should be something like this: /c removevote#name", Username, true);
            return;
        }
        if (Username.equals(recipientName)) {
            CampaignMain.cm.toUser("AM:You may not vote for youself.", Username, true);
            return;
        }
        boolean canVote = new Boolean(CampaignMain.cm.getConfig("VotingEnabled"));
        if (!canVote) {
            CampaignMain.cm.toUser("AM:Voting is disabled on this server.", Username, true);
            return;
        }
        Vector<Vote> castersVotes = CampaignMain.cm.getVoteManager().getAllVotesBy(castingPlayer);
        if (castersVotes.isEmpty()) {
            CampaignMain.cm.toUser("AM:You have not cast any votes. Removal is impossible.", Username, true);
            return;
        }
        SPlayer recipientPlayer = CampaignMain.cm.getPlayer(recipientName);
        if (recipientPlayer == null) {
            CampaignMain.cm.toUser("AM:You can't remove a vote for a player who doesn't exist.", Username, true);
            return;
        }
        Enumeration<Vote> e = castersVotes.elements();
        boolean hasVoteForRecipient = false;
        Vote v = null;
        while (e.hasMoreElements() && !hasVoteForRecipient) {
            v = e.nextElement();
            if (!v.getRecipient().equals(recipientName)) continue;
            hasVoteForRecipient = true;
        }
        if (!hasVoteForRecipient) {
            CampaignMain.cm.toUser("AM:You have not voted for this player.", Username, true);
            return;
        }
        boolean voteRemoved = CampaignMain.cm.getVoteManager().removeVote(v);
        if (!voteRemoved) {
            CampaignMain.cm.toUser("AM:There was an error removing the vote. Please contact your server admin or file a bug report.", Username, true);
            return;
        }
        CampaignMain.cm.toUser("AM:Your vote for " + recipientName + " has been removed.", Username, true);
    }
}

