/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Tank;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.util.RepairTrackingThread;

public class RepairUnitCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            int damagedCrits;
            int unitID = Integer.parseInt(command.nextToken());
            int location = Integer.parseInt(command.nextToken());
            int slot = Integer.parseInt(command.nextToken());
            boolean armor = Boolean.parseBoolean(command.nextToken());
            int techType = Integer.parseInt(command.nextToken());
            int retries = Integer.parseInt(command.nextToken());
            int techWorkMod = Integer.parseInt(command.nextToken());
            boolean sendDialogUpdate = Boolean.parseBoolean(command.nextToken());
            retries = Math.max(0, retries);
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SUnit unit = player.getUnit(unitID);
            Entity entity = unit.getEntity();
            String repairMessage = "";
            int tabLocation = location;
            int cost = CampaignMain.cm.getRepairCost(entity, location, slot, techType, armor, techWorkMod);
            if (unit.getType() == 2) {
                CampaignMain.cm.toUser("FSM|Infantry cannot be repaired.", Username, false);
                return;
            }
            if (CampaignMain.cm.getRTT().isBeingRepaired(unitID, location, slot, armor)) {
                CampaignMain.cm.toUser("FSM|That section is already being repaired wait for the work to finish before starting again.", Username, false);
                return;
            }
            if (player.isUnitInLockedArmy(unitID)) {
                CampaignMain.cm.toUser("FSM|Sorry but that unit is currently in combat and may not be repaired.", Username, false);
                return;
            }
            if (techType != 5 && cost > player.getMoney()) {
                CampaignMain.cm.toUser("FSM|You do not have enough " + CampaignMain.cm.moneyOrFluMessage(true, false, -cost) + " to repair this location.", Username, false);
                return;
            }
            if (techType == 5 && cost > player.getReward()) {
                CampaignMain.cm.toUser("FSM|You do not have enough reward points to repair this location.", Username, false);
                return;
            }
            if (player.getDutyStatus() == 3 && player.getAmountOfTimesUnitExistsInArmies(unitID) > 0) {
                CampaignMain.cm.toUser("FSM|You may not repair that unit while it is in an active army.", Username, false);
                return;
            }
            int numberOfTechs = 1;
            if (techType < 4) {
                numberOfTechs = player.getAvailableTechs().elementAt(techType);
            }
            if (techType == 4 && unit.getPilot() != null && unit.getLastCombatPilot() != unit.getPilot().getPilotId()) {
                CampaignMain.cm.toUser("FSM|" + unit.getPilot().getName() + " refuses to repair a unit he does not remember damaging himself!", Username, false);
                return;
            }
            if (numberOfTechs <= 0) {
                CampaignMain.cm.toUser("FSM|You do not have any " + UnitUtils.techDescription(techType) + " techs to do this repair!", Username, false);
                return;
            }
            if (techType != 5 && CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                String crit = UnitUtils.getCritName(entity, slot, location, armor);
                damagedCrits = UnitUtils.getNumberOfDamagedCrits(entity, slot, location, armor);
                if (player.getPartsAmount(crit) < damagedCrits) {
                    if (player.getAutoReorder()) {
                        String newCommand = crit + "#" + damagedCrits;
                        CampaignMain.cm.getServerCommands().get("BUYPARTS").process(new StringTokenizer(newCommand, "#"), Username);
                        if (player.getPartsAmount(crit) >= damagedCrits) {
                            newCommand = unitID + "#" + location + "#" + slot + "#" + armor + "#" + techType + "#" + retries + "#" + techWorkMod + "#" + sendDialogUpdate;
                            CampaignMain.cm.getServerCommands().get("REPAIRUNIT").process(new StringTokenizer(newCommand, "#"), Username);
                            return;
                        }
                    }
                    String critPrettyname = UnitUtils.getCritExternalName(entity, slot, location, armor);
                    CampaignMain.cm.toUser("FSM|You do not have enough " + critPrettyname + " crits to repair this.", Username, false);
                    return;
                }
            }
            if ((repairMessage = UnitUtils.getRepairMessage(entity, tabLocation, slot, armor)).length() > 0) {
                CampaignMain.cm.toUser("FSM|" + repairMessage, Username, false);
                return;
            }
            if (armor) {
                boolean rear = false;
                if (slot < 15) {
                    if (entity instanceof Tank) {
                        rear = false;
                    } else {
                        switch (location) {
                            case 8: {
                                tabLocation = 1;
                                rear = true;
                                break;
                            }
                            case 10: {
                                tabLocation = 3;
                                rear = true;
                                break;
                            }
                            case 9: {
                                tabLocation = 2;
                                rear = true;
                                break;
                            }
                            default: {
                                rear = slot == 14;
                            }
                        }
                    }
                    repairMessage = rear ? "Repairs have begun on the external armor(" + entity.getLocationAbbr(tabLocation) + "r) of your " + entity.getShortNameRaw() + ".  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>" : "Repairs have begun on the external armor(" + entity.getLocationAbbr(tabLocation) + ") of your " + entity.getShortNameRaw() + ".  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>";
                } else {
                    repairMessage = "Repairs have begun on the internal structure(" + entity.getLocationAbbr(location) + ") of your " + entity.getShortNameRaw() + ".  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>";
                }
            } else {
                CriticalSlot cs = entity.getCritical(location, slot);
                if (cs.getType() == 1) {
                    Mounted mounted = entity.getEquipment(cs.getIndex());
                    repairMessage = "Work has begun on the " + mounted.getName() + "(" + entity.getLocationAbbr(location) + ") for your " + entity.getShortNameRaw() + ".  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>";
                } else if (UnitUtils.isEngineCrit(cs)) {
                    repairMessage = "Work on your " + entity.getShortNameRaw() + "'s engine has begun.  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>";
                } else if (entity instanceof Mech) {
                    repairMessage = "Work has begun on the " + ((Mech)entity).getSystemName(cs.getIndex()) + "(" + entity.getLocationAbbr(location) + ") for your " + entity.getShortName() + ".  <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>";
                }
            }
            if (CampaignMain.cm.getRTT().getState() == Thread.State.TERMINATED) {
                CampaignMain.cm.toUser("FSM|Sorry your repair order could not be processed, and the repair thread terminated. Staff was notified.", Username, false);
                CampaignData.mwlog.errLog("NOTE: Repair Thread terminated! Use the restartrepairthread command to restart. If all else fails, reboot.");
                return;
            }
            if (techType == 4) {
                unit.setPilotIsRepairing(true);
            }
            if (techType == 5) {
                player.addReward(-cost);
            } else {
                player.addMoney(-cost);
                unit.addRepairCost(cost);
                if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                    String crit = UnitUtils.getCritName(entity, slot, location, armor);
                    damagedCrits = UnitUtils.getNumberOfDamagedCrits(entity, slot, location, armor);
                    if (crit.indexOf("Ammo") > -1) {
                        crit = "Ammo Bin";
                        damagedCrits = 1;
                    }
                    player.updatePartsCache(crit, -damagedCrits);
                }
            }
            player.setSave();
            CampaignMain.cm.getRTT().getRepairList().add(RepairTrackingThread.Repair(player, unitID, armor, location, slot, techType, retries, techWorkMod, false));
            CampaignMain.cm.toUser("FSM|" + repairMessage, Username, false);
            CampaignMain.cm.toUser("PL|UU|" + unitID + "|" + unit.toString(true), Username, false);
            if (sendDialogUpdate) {
                CampaignMain.cm.toUser("ARD|" + unitID, Username, false);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to Process Repair Unit Command!");
            CampaignData.mwlog.errLog(ex);
        }
    }
}

