/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.House;
import common.Unit;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Mech;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepodCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";
    private boolean global = false;

    @Override
    public int getExecutionLevel() {
        return this.accessLevel;
    }

    @Override
    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        this.global = false;
        if (command.hasMoreElements()) {
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int unitid = Integer.parseInt(command.nextToken());
            SUnit m = p.getUnit(unitid);
            SHouse h = p.getHouseFightingFor();
            String target = "<none>";
            if (m == null) {
                CampaignMain.cm.toUser("AM:You do not have a unit with ID# " + unitid + ".", Username, true);
                return;
            }
            if (p.mayAcquireWelfareUnits()) {
                CampaignMain.cm.toUser("AM:You may not repod your units while you are on welfare!", Username, true);
                return;
            }
            if (UnitUtils.hasArmorDamage(m.getEntity()) || UnitUtils.hasCriticalDamage(m.getEntity())) {
                CampaignMain.cm.toUser("AM:This unit is currently damaged and cannot be repodded until you repair it.", Username, true);
                return;
            }
            if (command.hasMoreTokens() && (target = command.nextToken()).equals("GLOBAL")) {
                this.global = true;
                target = command.hasMoreTokens() ? command.nextToken() : "<none>";
            }
            if (!m.isOmni()) {
                CampaignMain.cm.toUser("AM:Your " + m.getVerboseModelName() + " is not an Omni.", Username, true);
                return;
            }
            if (p.getAmountOfTimesUnitExistsInArmies(m.getId()) > 0) {
                CampaignMain.cm.toUser("AM:You may not repod a unit while it is in an army.", Username, true);
                return;
            }
            Entity mEnt = m.getEntity();
            String targetChassis = mEnt.getChassis();
            Vector<Object> possible = new Vector(1, 1);
            Vector<String> tables = new Vector<String>(1, 1);
            if (this.global) {
                String string;
                Iterator<House> Houses = CampaignMain.cm.getData().getAllHouses().iterator();
                String string2 = "";
                String timeZone = h.getConfig("RewardsRepodFolder");
                while (Houses.hasNext()) {
                    SHouse faction = (SHouse)Houses.next();
                    String string3 = BuildTable.getFileName(faction.getName(), Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType());
                    if (tables.contains(string3)) continue;
                    tables.add(string3);
                }
                if (Boolean.parseBoolean(h.getConfig("UseCommonTableForRepod")) && !tables.contains(string = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType()))) {
                    tables.add(string);
                }
            } else if (!Boolean.parseBoolean(h.getConfig("RepodUsesFactory"))) {
                String fileName = "";
                String string = h.getConfig("NoFactoryRepodFolder");
                fileName = BuildTable.getFileName(h.getName(), Unit.getWeightClassDesc(m.getWeightclass()), string, m.getType());
                if (!tables.contains(fileName)) {
                    tables.add(fileName);
                }
                if (Boolean.parseBoolean(h.getConfig("UseCommonTableForRepod")) && !tables.contains(fileName = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), string, m.getType()))) {
                    tables.add(fileName);
                }
            } else {
                possible = p.getMyHouse().getPossibleFactoryForProduction(m.getType(), m.getWeightclass(), false);
                for (SUnitFactory sUnitFactory : possible) {
                    String fileName = BuildTable.getFileName(sUnitFactory.getFounder(), Unit.getWeightClassDesc(m.getWeightclass()), sUnitFactory.getBuildTableFolder(), m.getType());
                    if (!tables.contains(fileName)) {
                        tables.add(fileName);
                    }
                    if (!Boolean.parseBoolean(h.getConfig("UseCommonTableForRepod")) || tables.contains(fileName = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), sUnitFactory.getBuildTableFolder(), m.getType()))) continue;
                    tables.add(fileName);
                }
            }
            if (!target.equals("<none>")) {
                if (target.equals("RANDOM")) {
                    if (!Boolean.parseBoolean(h.getConfig("RandomRepodAllowed"))) {
                        CampaignMain.cm.toUser("Random repodding is not allowed.", Username, true);
                        return;
                    }
                } else if (Boolean.parseBoolean(h.getConfig("RandomRepodOnly"))) {
                    CampaignMain.cm.toUser("Only random repods are allowed.", Username, true);
                    return;
                }
            }
            String result = "";
            Vector<String> vector = new Vector<String>(1, 1);
            int i = tables.size();
            if (i < 1) {
                CampaignMain.cm.toUser("AM:Repod Failed: No acceptable factory currently available", Username, true);
                return;
            }
            while (i > 0) {
                String prodFile = (String)tables.elementAt(--i);
                try {
                    FileInputStream fis = new FileInputStream(prodFile);
                    BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                    while (dis.ready()) {
                        String l = dis.readLine();
                        StringTokenizer ST = new StringTokenizer(l);
                        if (ST.hasMoreElements()) {
                            ST.nextElement();
                            String Filename = "";
                            while (ST.hasMoreElements()) {
                                Filename = Filename + (String)ST.nextElement();
                                if (!ST.hasMoreElements()) continue;
                                Filename = Filename + " ";
                            }
                            if (!Filename.toLowerCase().startsWith(targetChassis.toLowerCase())) continue;
                            SUnit cm = new SUnit(unitid, m.getProducer(), Filename);
                            Entity cme = cm.getEntity();
                            String chassis = cme.getChassis();
                            if (!cm.isOmni() || !chassis.equalsIgnoreCase(targetChassis)) continue;
                            String model = cm.getModelName();
                            if (target.equals("<none>") || target.equals("RANDOM")) {
                                if (target.equals("RANDOM") && cm.getModelName().equals(m.getModelName()) || vector.contains(Filename)) continue;
                                vector.add(Filename);
                                String repodMoneyCfg = "RepodCost" + Unit.getWeightClassDesc(cm.getWeightclass());
                                String repodInfluCfg = "RepodFlu" + Unit.getWeightClassDesc(cm.getWeightclass());
                                String repodCompCfg = "RepodComp" + Unit.getWeightClassDesc(cm.getWeightclass());
                                int repodMoneyMod = Integer.parseInt(h.getConfig(repodMoneyCfg));
                                int repodFluMod = Integer.parseInt(h.getConfig(repodInfluCfg));
                                int repodCompMod = Integer.parseInt(h.getConfig(repodCompCfg));
                                if (CampaignMain.cm.getOmniVariantMods().get(model) != null) {
                                    String mods = CampaignMain.cm.getOmniVariantMods().get(model);
                                    StringTokenizer modlist = new StringTokenizer(mods, "$");
                                    repodMoneyMod += Integer.parseInt(modlist.nextToken());
                                    repodCompMod += Integer.parseInt(modlist.nextToken());
                                    repodFluMod += Integer.parseInt(modlist.nextToken());
                                }
                                result = result + model + "#" + repodMoneyMod + "$" + repodCompMod + "$" + repodFluMod + "#";
                                continue;
                            }
                            if (!target.equalsIgnoreCase(model)) continue;
                            this.createOmni(m, Filename, m.getId(), p, possible, false);
                            return;
                        }
                        CampaignData.mwlog.mainLog("File " + prodFile + " has a problem with line:" + l);
                    }
                    dis.close();
                    fis.close();
                }
                catch (FileNotFoundException ex) {
                    CampaignData.mwlog.mainLog("File " + prodFile + " was not Found");
                }
                catch (IOException ex) {
                    CampaignData.mwlog.mainLog("File " + prodFile + " had an I/O error");
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.mainLog("File " + prodFile + " has a problem");
                }
            }
            if (target.equals("RANDOM")) {
                int size = vector.size();
                if (size <= 0) {
                    CampaignMain.cm.toUser("AM:No random targets available for " + m.getModelName() + ".", Username, true);
                    return;
                }
                if (size == 1) {
                    String Filename = (String)vector.elementAt(0);
                    this.createOmni(m, Filename, m.getId(), p, possible, true);
                    return;
                }
                int number = CampaignMain.cm.getRandomNumber(size);
                String Filename = (String)vector.elementAt(number);
                this.createOmni(m, Filename, m.getId(), p, possible, true);
                return;
            }
            if (this.global) {
                result = result + "#GLOBAL";
            }
            CampaignMain.cm.toUser("RUD|" + unitid + "|" + result, Username, false);
        }
    }

    private void createOmni(SUnit m, String Filename, int unitid, SPlayer p, Vector<SUnitFactory> possible, boolean random) {
        SUnit cm;
        SHouse h = p.getHouseFightingFor();
        String Username = p.getName();
        int influenceCost = 0;
        int moneyCost = 0;
        int compCost = 0;
        int refreshTime = 0;
        int rpCost = Integer.parseInt(h.getConfig("GlobalRepodWithRPCost"));
        if (random) {
            rpCost /= 2;
        }
        if ((cm = new SUnit(unitid, m.getProducer(), Filename)).getModelName().equals("OMG-UR-FD")) {
            CampaignMain.cm.toUser("AM:Invaild repod format try again!", Username, true);
            return;
        }
        if (!this.global) {
            String needPartsList = p.getUnitParts().canRepodUnit(m.getEntity(), cm.getEntity()).trim();
            if (CampaignMain.cm.getBooleanConfig("UsePartsRepair") && needPartsList.length() > 0) {
                CampaignMain.cm.toUser("You do not have enough parts to repod your " + m.getModelName() + " to " + cm.getModelName() + "<br> you need the following parts:<br>" + needPartsList, Username);
                return;
            }
            String repodMoneyCfg = "RepodCost" + Unit.getWeightClassDesc(m.getWeightclass());
            String repodInfluCfg = "RepodFlu" + Unit.getWeightClassDesc(m.getWeightclass());
            String repodCompCfg = "RepodComp" + Unit.getWeightClassDesc(m.getWeightclass());
            String repodRefreshCfg = "RepodRefreshTime" + Unit.getWeightClassDesc(m.getWeightclass());
            int repodMoneyMod = 0;
            int repodCompMod = 0;
            int repodFluMod = 0;
            if (CampaignMain.cm.getOmniVariantMods().get(cm.getModelName()) != null) {
                String mods = CampaignMain.cm.getOmniVariantMods().get(cm.getModelName());
                StringTokenizer modList = new StringTokenizer(mods, "$");
                repodMoneyMod = Integer.parseInt(modList.nextToken());
                repodCompMod = Integer.parseInt(modList.nextToken());
                repodFluMod = Integer.parseInt(modList.nextToken());
            }
            int repodRandomMod = Integer.parseInt(h.getConfig("RepodRandomMod"));
            if (Boolean.parseBoolean(h.getConfig("DoesRepodCost"))) {
                moneyCost = Integer.parseInt(h.getConfig(repodMoneyCfg)) + repodMoneyMod;
                if (random) {
                    moneyCost = moneyCost * repodRandomMod / 100;
                }
                if (p.getMoney() < moneyCost) {
                    CampaignMain.cm.toUser("AM:You do not have enough money to repod this unit! It will cost " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " to repod this unit", Username, true);
                    return;
                }
                influenceCost = Integer.parseInt(h.getConfig(repodInfluCfg)) + repodFluMod;
                if (random) {
                    influenceCost = influenceCost * repodRandomMod / 100;
                }
                if (p.getInfluence() < influenceCost) {
                    CampaignMain.cm.toUser("AM:You do not have enough influence to repod this unit! It will cost " + CampaignMain.cm.moneyOrFluMessage(false, false, influenceCost) + " to repod this unit!", Username, true);
                    return;
                }
                if (Boolean.parseBoolean(h.getConfig("RepodUsesComp"))) {
                    compCost = Integer.parseInt(h.getConfig(repodCompCfg)) + repodCompMod;
                    if (random) {
                        compCost = compCost * repodRandomMod / 100;
                    }
                    if (h.getPP(m.getWeightclass(), m.getType()) < compCost) {
                        CampaignMain.cm.toUser("AM:Your faction doesn't have enough components to repod this unit. You need " + compCost + " components to repod.", Username, true);
                        return;
                    }
                }
                StringBuilder hsUpdates = new StringBuilder();
                if (Boolean.parseBoolean(h.getConfig("RepodUsesFactory"))) {
                    SUnitFactory working = possible.elementAt(0);
                    refreshTime = Integer.parseInt(h.getConfig(repodRefreshCfg));
                    if (random) {
                        refreshTime = refreshTime * repodRandomMod / 100;
                    }
                    hsUpdates.append(working.addRefresh(refreshTime, false));
                }
                hsUpdates.append(h.addPP(m.getWeightclass(), m.getType(), -compCost, false));
                if (hsUpdates.length() > 0) {
                    CampaignMain.cm.doSendToAllOnlinePlayers(h, "HS|" + hsUpdates.toString(), false);
                }
                p.addMoney(-moneyCost);
                p.addInfluence(-influenceCost);
            }
        } else {
            if (p.getReward() < rpCost) {
                CampaignMain.cm.toUser("AM:You do not have enough reward points to repod this unit!", Username, true);
                return;
            }
            p.addReward(-rpCost);
        }
        cm.setPilot((SPilot)m.getPilot());
        cm.setExperience(m.getExperience());
        Entity entity = p.getUnit(unitid).getEntity();
        if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            p.getUnitParts().repodUnit(entity, cm.getEntity());
            CampaignMain.cm.toUser("PL|RPPC|" + p.getUnitParts().toString(), Username, false);
        }
        if (cm.getType() == 0) {
            ((Mech)cm.getEntity()).setAutoEject(((Mech)entity).isAutoEject());
        }
        if (UnitUtils.hasTargettingComputer(cm.getEntity())) {
            cm.getEntity().setTargSysType(1);
        } else {
            cm.getEntity().setTargSysType(entity.getTargetType());
        }
        cm.getEntity().setSpotlight(entity.hasSpotlight());
        cm.getEntity().setSpotlightState(entity.isUsingSpotlight());
        cm.setWeightclass(m.getWeightclass());
        cm.setType(m.getType());
        p.removeUnit(unitid, false);
        p.addUnit(cm, true);
        CampaignMain.cm.toUser("AM:Your " + m.getVerboseModelName() + " is now " + StringUtils.aOrAn(cm.getVerboseModelName(), true) + ".", Username, true);
        if (!this.global) {
            if (new Boolean(h.getConfig("RepodUsesComp")).booleanValue()) {
                CampaignMain.cm.toUser("AM:Repodding cost " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, influenceCost) + " " + compCost + " Components.", Username, true);
            } else {
                CampaignMain.cm.toUser("AM:Repodding cost " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, influenceCost) + ".", Username, true);
            }
        } else {
            CampaignMain.cm.toUser("AM:Repodding cost " + rpCost + " reward points.", Username, true);
        }
    }
}

