/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class RequestBuildTableCommand
implements Command {
    int accessLevel = 2;
    String syntax = "list";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String subcommand = command.nextToken();
        if (subcommand.equalsIgnoreCase("list")) {
            StringBuilder toReturn = new StringBuilder();
            String folderDelimiter = "?";
            String fileDelimiter = "*";
            String[] folderList = new String[]{"standard"};
            boolean viewer = false;
            if (command.hasMoreTokens()) {
                viewer = Boolean.parseBoolean(command.nextToken());
            }
            for (int i = 0; i < folderList.length; ++i) {
                File[] fileNames;
                File currF = new File("./data/buildtables/" + folderList[i]);
                toReturn.append(folderList[i]);
                toReturn.append(folderDelimiter);
                if (!currF.exists() || !currF.isDirectory()) continue;
                for (File currFile : fileNames = currF.listFiles()) {
                    if (!currFile.getName().endsWith("txt")) continue;
                    toReturn.append(currFile.getName());
                    toReturn.append(fileDelimiter);
                }
                toReturn.append(folderDelimiter);
            }
            CampaignMain.cm.toUser("BT|PLS|" + toReturn.toString() + "|" + viewer, Username, false);
            CampaignData.mwlog.dbLog("Sending: " + toReturn.toString());
            return;
        }
        if (subcommand.equalsIgnoreCase("get")) {
            StringBuilder toReturn = new StringBuilder();
            String folder = "";
            String table = "";
            long time = 0L;
            if (command.hasMoreTokens()) {
                folder = command.nextToken();
            }
            if (command.hasMoreTokens()) {
                table = command.nextToken();
            }
            if (command.hasMoreTokens()) {
                time = Long.parseLong(command.nextToken());
            }
            if (folder.length() == 0 || table.length() == 0) {
                CampaignMain.cm.toUser("Bad Build Table Request: " + (folder.length() == 0 ? "Empty folder name" : "Empty file name"), Username, true);
                return;
            }
            File file = new File("./data/buildtables/" + folder + "/" + table);
            if (!file.exists()) {
                CampaignMain.cm.toUser("Bad Build Table Request: " + folder + "/" + table + " does not exist.", Username, true);
                return;
            }
            if (time >= file.lastModified()) {
                return;
            }
            try {
                FileInputStream in = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                try {
                    while (br.ready()) {
                        toReturn.append("|" + br.readLine());
                    }
                    br.close();
                    in.close();
                }
                catch (IOException ex) {}
            }
            catch (FileNotFoundException e) {
                CampaignData.mwlog.errLog(e);
            }
            CampaignMain.cm.toUser("BT|BT|" + folder + "|" + table + toReturn.toString(), Username, false);
        } else if (subcommand.equalsIgnoreCase("view")) {
            CampaignMain.cm.toUser("BT|VS|DONE#DONE", Username, false);
        }
    }
}

