/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.io.File;
import java.util.StringTokenizer;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class RequestDonatedCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int weightclass = 0;
        int type_id = 0;
        String result = "";
        boolean useBays = CampaignMain.cm.isUsingAdvanceRepair();
        String weightstring = command.nextToken().toUpperCase();
        try {
            weightclass = Integer.parseInt(weightstring);
        }
        catch (Exception ex) {
            weightclass = Unit.getWeightIDForName(weightstring);
        }
        String typestring = command.nextToken();
        try {
            type_id = Integer.parseInt(typestring);
        }
        catch (Exception ex) {
            type_id = Unit.getTypeIDForName(typestring);
        }
        if (p.getMyHouse().isNewbieHouse()) {
            result = "AM:Players in the training faction may not purchase used/donated units; however, they may reset their units.";
            result = result + "AM:<br><a href=\"MEKWARS/c request#resetunits\">Click here to request a reset of your units.</a>";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            SUnit unit = this.buildWelfareMek(house.getName());
            SPilot pilot = house.getNewPilot(unit.getType());
            unit.setPilot(pilot);
            p.addUnit(unit, true);
            CampaignMain.cm.toUser("AM:High Command has given you a Mek from its welfare rolls to help you get back on your feet!", Username, true);
            return;
        }
        if (!p.mayUse(weightclass)) {
            result = "AM:You are not experienced enough to use " + Unit.getWeightClassDesc(weightclass) + " units.";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        SUnit u = house.getEntity(weightclass, type_id);
        if (u == null) {
            result = "AM:There is no unit of the requested weight class/type avaliable";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (!Boolean.parseBoolean(p.getSubFaction().getConfig("CanBuyUsed" + SUnit.getWeightClassDesc(weightclass) + SUnit.getTypeClassDesc(type_id)))) {
            CampaignMain.cm.toUser("AM:Sorry as a member of " + p.getSubFactionName() + " you are unable to purchase this unit.", Username);
            return;
        }
        if (p.hasUnmaintainedUnit()) {
            result = "AM:Your faction refuses to assign additional units to you force while existing resources are not being properly maintained!";
            house.addUnit(u, false);
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        int unitCbills = Math.round(Float.parseFloat(house.getConfig("UsedPurchaseCostMulti")) * (float)house.getPriceForUnit(u.getWeightclass(), u.getType()));
        int unitInfluence = Math.round(Float.parseFloat(house.getConfig("UsedPurchaseCostMulti")) * (float)house.getInfluenceForUnit(u.getWeightclass(), u.getType()));
        if (unitCbills < 0) {
            unitCbills = 0;
        }
        if (unitInfluence < 0) {
            unitInfluence = 0;
        }
        if (Boolean.parseBoolean(house.getConfig("UseCalculatedCosts"))) {
            double costMulti = house.getDoubleConfig("UsedPurchaseCostMulti");
            double unitCost = u.getEntity().getCost();
            if (unitCost < 1.0) {
                unitCost = house.getPriceForUnit(u.getWeightclass(), u.getType());
            }
            double costMod = house.getDoubleConfig("CostModifier");
            unitCbills = (int)Math.round(costMulti * unitCost * costMod);
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            if (!UnitUtils.canStartUp(u.getEntity())) {
                unitCbills = Math.round((float)unitCbills * Float.parseFloat(house.getConfig("CostModifierToBuyEnginedUnit")));
            } else if (UnitUtils.hasCriticalDamage(u.getEntity())) {
                unitCbills = Math.round((float)unitCbills * Float.parseFloat(house.getConfig("CostModifierToBuyCritDamagedUnit")));
            } else if (UnitUtils.hasArmorDamage(u.getEntity())) {
                unitCbills = Math.round((float)unitCbills * Float.parseFloat(house.getConfig("CostModifierToBuyArmorDamagedUnit")));
            }
        }
        if (unitCbills > p.getMoney() || unitInfluence > p.getInfluence()) {
            house.addUnit(u, false);
            CampaignMain.cm.toUser("AM:You cannot afford to purchase " + StringUtils.aOrAn(Unit.getWeightClassDesc(u.getWeightclass()), true) + " " + Unit.getTypeClassDesc(u.getType()) + " from the faction bay (Requires " + CampaignMain.cm.moneyOrFluMessage(true, false, unitCbills) + ", " + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ").", Username, true);
            return;
        }
        int spaceTaken = SUnit.getHangarSpaceRequired(type_id, weightclass, 0, "null", p.getMyHouse());
        if (spaceTaken > p.getFreeBays()) {
            int numTechs;
            int totalCost;
            int techCost = p.getTechHiringFee();
            if (useBays) {
                techCost = Integer.parseInt(house.getConfig("CostToBuyNewBay"));
            }
            if ((totalCost = unitCbills + (techCost *= (numTechs = spaceTaken - p.getFreeBays()))) > p.getMoney()) {
                result = useBays ? "AM:Command will not assign the requested unit to your force unless support is in place; however, you cannot afford to buy the unit *and* purchase bays. Total cost would be " + CampaignMain.cm.moneyOrFluMessage(true, false, totalCost) + " and you only have " + p.getMoney() + "." : "AM:Command will not assign the requested unit to your force unless support is in place; however, you cannot afford to buy the unit *and* hire technicians. Total cost would be " + CampaignMain.cm.moneyOrFluMessage(true, false, totalCost) + " and you only have " + p.getMoney() + ".";
                house.addUnit(u, false);
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            if (useBays) {
                result = "AM:Quartermaster command will not release the requested unit to your force unless support resources are in place. You will need to purchase " + numTechs + " more bays (total cost: " + CampaignMain.cm.moneyOrFluMessage(true, true, techCost) + "). Combined cost of the requested unit and necessary " + "bays is " + CampaignMain.cm.moneyOrFluMessage(true, true, totalCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ".";
                result = result + "<br><a href=\"MEKWARS/c hireandrequestused#" + numTechs + "#" + Unit.getWeightClassDesc(weightclass) + "#" + type_id + "\">Click here to purchase the bays and purchase the unit.</a>";
            } else {
                result = "AM:Quartermaster command will not release the requested unit to your force unless support resources are in place. You will need to hire " + numTechs + " more technicians (total tech cost: " + CampaignMain.cm.moneyOrFluMessage(true, true, techCost) + "). Combined cost of the requested unit and necessary " + "technicians is " + CampaignMain.cm.moneyOrFluMessage(true, true, totalCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ".";
                result = result + "<br><a href=\"MEKWARS/c hireandrequestused#" + numTechs + "#" + Unit.getWeightClassDesc(weightclass) + "#" + type_id + "\">Click here to hire the technicians and purchase the unit.</a>";
            }
            house.addUnit(u, false);
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (!(!u.hasVacantPilot() || u.isSinglePilotUnit() && CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues"))) {
            u.setPilot(p.getMyHouse().getNewPilot(type_id));
        }
        p.addUnit(u, true);
        p.addMoney(-unitCbills);
        p.addInfluence(-unitInfluence);
        result = "AM:You've been granted a " + u.getModelName() + ". (-" + CampaignMain.cm.moneyOrFluMessage(true, false, unitCbills) + " / -" + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ") ";
        CampaignMain.cm.toUser(result, Username, true);
        CampaignMain.cm.doSendHouseMail(house, "NOTE", p.getName() + " bought " + StringUtils.aOrAn(u.getVerboseModelName(), true) + " from the faction bay!");
        CampaignMain.cm.doSendToAllOnlinePlayers(house, "HS|" + house.getHSUnitRemovalString(u), false);
    }

    private SUnit buildWelfareMek(String producer) {
        String Filename = "./data/buildtables/standard/" + producer + "_Welfare.txt";
        if (!new File(Filename).exists()) {
            Filename = "./data/buildtables/standard/Welfare.txt";
        }
        String unitFileName = BuildTable.getUnitFilename(Filename);
        SUnit cm = new SUnit(producer, unitFileName, 0);
        return cm;
    }
}

