/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.SubFaction;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RequestSubFactionPromotionCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String subFactionName;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse faction = player.getMyHouse();
        SubFaction subFaction = null;
        try {
            subFactionName = command.nextToken();
            subFaction = faction.getSubFactionList().get(subFactionName);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid Syntax: /RequestSubFactionPromotion subFactionname", Username);
            return;
        }
        if (subFaction == null) {
            CampaignMain.cm.toUser("AM:That SubFaction does not exist for faction " + faction.getName() + ".", Username);
            return;
        }
        int minELO = Integer.parseInt(subFaction.getConfig("MinELO"));
        int minEXP = Integer.parseInt(subFaction.getConfig("MinExp"));
        if (player.getExperience() < minEXP || player.getRating() < (double)minELO) {
            CampaignMain.cm.toUser("AM:Sorry but you are not skilled enough to join that SubFaction.", Username);
            return;
        }
        if (player.getSubFactionAccess() > Integer.parseInt(subFaction.getConfig("AccessLevel"))) {
            CampaignMain.cm.toUser("AM:Sorry but you cannot demote yourself", Username);
            return;
        }
        if (!player.canBePromoted()) {
            CampaignMain.cm.toUser("AM:Sorry but you've already been premoted once within a " + player.getMyHouse().getIntegerConfig("daysbetweenpromotions") + " day period.", Username);
            return;
        }
        if (CampaignMain.cm.getBooleanConfig("autoPromoteSubFaction")) {
            player.setSubFaction(subFactionName);
            CampaignMain.cm.toUser("PL|SSN|" + subFactionName, Username, false);
            CampaignMain.cm.toUser("HS|CA|0", player.getName(), false);
            CampaignMain.cm.toUser(player.getMyHouse().getCompleteStatus(), player.getName(), false);
            CampaignMain.cm.toUser("AM:Congratulations you have been promoted to SubFaction " + subFactionName + ".", Username);
            CampaignMain.cm.doSendHouseMail(player.getMyHouse(), "NOTE", player.getName() + " has been promoted to subfaction " + subFactionName + "!");
        } else {
            CampaignMain.cm.toUser("AM:Your request for a promotion has been noted. Someone will be in touch.", Username);
            String msg = Username + " has requested for a promtion to subfaction " + subFactionName + " <a href=\"MEKWARS/c promoteplayer#" + Username + "#" + subFactionName + "\">Click here to promote.</a>";
            faction.sendMessageToHouseLeaders(msg);
            CampaignMain.cm.doSendModMail("NOTE", msg);
        }
    }
}

