/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.StringUtils;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.operations.OpsScrapThread;
import server.campaign.pilot.SPilot;

public class ScrapCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int scrapsAllowed = Integer.parseInt(house.getConfig("ScrapsAllowed"));
        if (scrapsAllowed <= 0) {
            CampaignMain.cm.toUser("AM:Scrapping is not allowed on this server.", Username, true);
            return;
        }
        if (house.isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:SOL players may not Sell, Scrap or Donate their units!", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("AM:You may not scrap any of your units while you are on welfare.", Username, true);
            return;
        }
        int mechid = -1;
        try {
            mechid = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Formatting error. Try: /c scrap#ID Number", Username, true);
            return;
        }
        SUnit m = p.getUnit(mechid);
        if (m == null) {
            CampaignMain.cm.toUser("AM:Could not find a unit with the given ID.", Username, true);
            return;
        }
        if (UnitUtils.isRepairing(m.getEntity())) {
            CampaignMain.cm.toUser("AM:This unit is currently being repaired. You cannot scrap it until the repairs are complete!", Username, true);
            return;
        }
        if (m.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:Units that are for sale on the Market may not be scrapped.", Username, true);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(mechid) > 0 && p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not scrap units which are in active armies.", Username, true);
            return;
        }
        if (p.isUnitInLockedArmy(m.getId())) {
            CampaignMain.cm.toUser("AM:You may not scrap units which are in fighting armies.", Username, true);
            return;
        }
        if (p.getScrapsThisTick() >= scrapsAllowed && m.getScrappableFor() <= 0) {
            CampaignMain.cm.toUser("AM:You may only scrap " + scrapsAllowed + " unit(s) per tick.", Username, true);
            return;
        }
        float costMulti = 0.0f;
        costMulti = !CampaignMain.cm.isUsingAdvanceRepair() || m.getType() != 0 ? Float.parseFloat(house.getConfig("ScrapCostMultiplier")) : (UnitUtils.getNumberOfDamagedEngineCrits(m.getEntity()) >= 3 ? Float.parseFloat(house.getConfig("CostToScrapEngined")) : (UnitUtils.hasCriticalDamage(m.getEntity()) ? Float.parseFloat(house.getConfig("CostToScrapCriticallyDamaged")) : (UnitUtils.hasArmorDamage(m.getEntity()) ? Float.parseFloat(house.getConfig("CostToScrapOnlArmorDamage")) : Float.parseFloat(house.getConfig("ScrapCostMultiplier")))));
        int moneyToScrap = Math.round((float)p.getMyHouse().getPriceForUnit(m.getWeightclass(), m.getType()) * costMulti);
        int infToScrap = (int)((float)p.getMyHouse().getInfluenceForUnit(m.getWeightclass(), m.getType()) * costMulti);
        if (infToScrap < 0) {
            infToScrap = 0;
        }
        if (p.getMoney() < moneyToScrap || p.getInfluence() < infToScrap && m.getScrappableFor() < 0) {
            CampaignMain.cm.toUser("AM:You cannot afford to scrap this unit. You need " + CampaignMain.cm.moneyOrFluMessage(true, true, moneyToScrap) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, infToScrap) + ".", Username, true);
            return;
        }
        if (m.getScrappableFor() >= 0) {
            p.addMoney(m.getScrappableFor());
            CampaignMain.cm.toUser("AM:You scrapped the " + m.getModelName() + " (" + CampaignMain.cm.moneyOrFluMessage(true, true, m.getScrappableFor(), true) + ").", Username, true);
        } else {
            p.addMoney(-moneyToScrap);
            p.addInfluence(-infToScrap);
            p.addScrapThisTick();
            CampaignMain.cm.toUser("AM:You scrapped the " + m.getModelName() + " (" + CampaignMain.cm.moneyOrFluMessage(true, true, -moneyToScrap, true) + ", " + CampaignMain.cm.moneyOrFluMessage(false, true, -infToScrap, true) + ").", Username, true);
        }
        CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " scrapped " + StringUtils.aOrAn(m.getVerboseModelName(), true) + ".");
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " scrapped a unit and sent himself into welfare.");
        }
        p.removeUnit(mechid, true);
        OpsScrapThread scrapT = CampaignMain.cm.getOpsManager().getScrapThreads().get(p.getName().toLowerCase());
        if (scrapT != null) {
            scrapT.scrapUnit(mechid);
        }
        if (Boolean.parseBoolean(house.getConfig("AllowPersonalPilotQueues")) && !m.hasVacantPilot() && m.isSinglePilotUnit()) {
            SPilot pilot = (SPilot)m.getPilot();
            p.getPersonalPilotQueue().addPilot(m.getPilot(), m.getWeightclass());
            CampaignMain.cm.toUser("PL|AP2PPQ|" + m.getType() + "|" + m.getWeightclass() + "|" + pilot.toFileFormat("#", true), Username, false);
            CampaignMain.cm.toUser(pilot.getName() + " was moved to your barracks.", Username, true);
            p.getPersonalPilotQueue().checkQueueAndWarn(p.getName(), m.getType(), m.getWeightclass());
        } else {
            p.getMyHouse().addDispossessedPilot(m, false);
        }
        CampaignMain.cm.addMechStat(m.getUnitFilename(), m.getWeightclass(), 0, 0, 1);
        int initialPP = p.getMyHouse().getPPCost(m.getWeightclass(), m.getType());
        p.getMyHouse().addPP(m.getWeightclass(), m.getType(), initialPP / 4, true);
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deleteUnit(m.getDBId());
        }
    }
}

