/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class SellBaysCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int numtosell = 1;
        try {
            numtosell = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:Couldn't tell how many bays to sell. Check your input. It should be something like this: /c sellbays#3", Username, true);
            return;
        }
        if (p.getBaysOwned() < numtosell) {
            CampaignMain.cm.toUser("AM:You tried to return " + numtosell + " bays, but you only have " + p.getBaysOwned() + " bays " + ". The rest were assigned to your force by your faction and can't be returned.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You may not return bays while you are engaged! Wait until your units are out of battle and fully repaired.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not return bays while you are active. Withdraw from the front lines before reducing your support levels.", Username, true);
            return;
        }
        if (p.getFreeBays() < numtosell) {
            CampaignMain.cm.toUser("AM:You need to free up some bay space before you can return anymore!", Username, true);
            return;
        }
        p.addBays(-numtosell);
        int sellbackprice = Integer.parseInt(house.getConfig("BaySellBackPrice")) * numtosell;
        p.addMoney(sellbackprice);
        if (numtosell == 1) {
            CampaignMain.cm.toUser("AM:You return a bay.  Your faction returns " + CampaignMain.cm.moneyOrFluMessage(true, true, sellbackprice) + " of your security deposit.", Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You return " + numtosell + " bays.  Your faction returns " + CampaignMain.cm.moneyOrFluMessage(true, true, sellbackprice) + " of your security deposit.", Username, true);
        }
        CampaignMain.cm.toUser("PL|SF|" + p.getFreeBays(), Username, false);
        CampaignMain.cm.toUser("PL|SB|" + p.getTotalMekBays(), Username, false);
        CampaignMain.cm.toUser("PL|ST|" + p.getBaysOwned(), Username, false);
    }
}

