/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SellCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:Players in training factions may not sell, scrap or donate their units.", Username, true);
            return;
        }
        if (!p.getMyHouse().maySellOnBM()) {
            CampaignMain.cm.toUser("AM:You are not allowed to sell units on the market. Your faction forbids it!", Username, true);
            return;
        }
        int minBMEXP = Integer.parseInt(house.getConfig("MinEXPforBMSelling"));
        if (p.getExperience() < minBMEXP) {
            CampaignMain.cm.toUser("AM:You are not allowed to sell units on the Market. Required Experience: " + minBMEXP + ".", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("AM:You may not auction any of your units while you are on welfare.", Username, true);
            return;
        }
        int unitID = -1;
        int salesTicks = -1;
        int minBid = -1;
        try {
            unitID = Integer.parseInt(command.nextToken());
            salesTicks = Integer.parseInt((String)command.nextElement());
            minBid = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c sell#unitid#ticks#minbid", Username, true);
            return;
        }
        SUnit unitToSell = p.getUnit(unitID);
        if (unitToSell == null) {
            CampaignMain.cm.toUser("AM:You do not have a unit with ID#" + unitToSell + ".", Username, true);
            return;
        }
        if (unitToSell.getStatus() == 2) {
            CampaignMain.cm.toUser("AM:You may not sell unmaintained units on the Market.", Username, true);
            return;
        }
        if (unitToSell.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:The " + unitToSell.getModelName() + " is already for sale.", Username, true);
            return;
        }
        if (unitToSell.getEntity().isClan() && Boolean.parseBoolean(house.getConfig("BMNoClan"))) {
            CampaignMain.cm.toUser("AM:Clan units may not be sold on the Market.", Username, true);
            return;
        }
        if (!SUnit.mayBeSoldOnMarket(unitToSell)) {
            CampaignMain.cm.toUser("AM:The " + unitToSell.getModelName() + " may not be sold on the Market.", Username, true);
            return;
        }
        int sellFluCost = Integer.parseInt(house.getConfig("BMSellFlu"));
        if (p.getInfluence() < (sellFluCost += unitToSell.getWeightclass() * house.getIntegerConfig("BMFluSizeCost"))) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(false, true, sellFluCost) + " to sell the " + unitToSell.getModelName() + ".", Username, true);
            return;
        }
        int minticks = Integer.parseInt(house.getConfig("MinBMSalesTicks"));
        int minprice = Integer.parseInt(house.getConfig("MinBMSalesPrice"));
        if (salesTicks < minticks) {
            CampaignMain.cm.toUser("AM:Units must be offered for at least " + minticks + " ticks.", Username, true);
            return;
        }
        if (minBid < minprice) {
            CampaignMain.cm.toUser("AM:Units must have a minimum asking price of at least " + CampaignMain.cm.moneyOrFluMessage(true, false, minprice) + ".", Username, true);
            return;
        }
        int maxticks = Integer.parseInt(house.getConfig("MaxBMSalesTicks"));
        int maxprice = Integer.parseInt(house.getConfig("MaxBMSalesPrice"));
        if (salesTicks > maxticks && maxticks > 0) {
            CampaignMain.cm.toUser("AM:Units may not be offered for more than " + maxticks + " ticks.", Username, true);
            return;
        }
        if (minBid > maxprice && maxprice > 0) {
            CampaignMain.cm.toUser("AM:Units may not have an asking price of more than  " + CampaignMain.cm.moneyOrFluMessage(true, false, maxprice) + ".", Username, true);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(unitID) > 0) {
            CampaignMain.cm.toUser("AM:The " + unitToSell.getModelName() + " must be removed from all armies before being added to the Market.", Username, true);
            return;
        }
        if (!Boolean.parseBoolean(house.getConfig("AllowSellingOfDamagedUnits")) && (UnitUtils.hasArmorDamage(unitToSell.getEntity()) || UnitUtils.hasCriticalDamage(unitToSell.getEntity()))) {
            CampaignMain.cm.toUser("AM:You may not sell damaged units on the black market!", Username, true);
            return;
        }
        CampaignMain.cm.getMarket().addListing(Username, unitToSell, minBid, salesTicks);
        p.addInfluence(-sellFluCost);
        CampaignMain.cm.toUser("AM:The " + unitToSell.getModelName() + " is now on the Market " + "(" + CampaignMain.cm.moneyOrFluMessage(false, false, -sellFluCost, true) + ").", Username, true);
        CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " added a unit to the market [" + unitToSell.getModelName() + "].");
        CampaignData.mwlog.bmLog(p.getName() + " added a " + unitToSell.getModelName() + ". Asking: " + minBid + ". Length: " + salesTicks);
    }
}

