/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.EdgeSkill;

public class SetEdgeSkillsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int unitid = 0;
        SPilot pilot = null;
        boolean edge_when_tac = true;
        boolean edge_when_ko = true;
        boolean edge_when_headhit = true;
        boolean edge_when_explosion = true;
        try {
            unitid = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:SetEdgeSkills command failed. Check your input. It should be something like this: /c SetEdgeSkills#unitid#true/false#true/false#true/false#true/false", Username, true);
            return;
        }
        try {
            edge_when_tac = new Boolean(command.nextToken());
            edge_when_ko = new Boolean(command.nextToken());
            edge_when_headhit = new Boolean(command.nextToken());
            edge_when_explosion = new Boolean(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:SetAutoEject Command failed. Check your input. It should be something like this: /c SetEdgeSkills#unitid#true/false#true/false#true/false#true/false", Username, true);
            return;
        }
        SUnit unit = p.getUnit(unitid);
        pilot = (SPilot)unit.getPilot();
        if (!pilot.getSkills().has(20)) {
            return;
        }
        ((EdgeSkill)pilot.getSkills().getPilotSkill(20)).setTac(edge_when_tac);
        ((EdgeSkill)pilot.getSkills().getPilotSkill(20)).setKO(edge_when_ko);
        ((EdgeSkill)pilot.getSkills().getPilotSkill(20)).setHeadHit(edge_when_headhit);
        ((EdgeSkill)pilot.getSkills().getPilotSkill(20)).setExplosion(edge_when_explosion);
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
        CampaignMain.cm.toUser("AM:Edge set for " + unit.getModelName(), Username, true);
    }
}

