/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetMaintainedCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int numtoset = 0;
        try {
            numtoset = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:SetMaintained command failed. Check your input. It should be something like this: /c setmaintained#12", Username, true);
            return;
        }
        SUnit unitToSet = p.getUnit(numtoset);
        if (unitToSet == null) {
            CampaignMain.cm.toUser("AM:Invalid id number. Make sure you're using the right unit number.", Username, true);
            return;
        }
        if (unitToSet.getStatus() == 1) {
            CampaignMain.cm.toUser("AM:This unit is already maintained.", Username, true);
            return;
        }
        if (unitToSet.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not change the maintenance status of a unit which is being sold.", Username, true);
            return;
        }
        int unitSpace = SUnit.getHangarSpaceRequired(unitToSet, p.getMyHouse());
        if (p.getFreeBays() < unitSpace) {
            int techCost = p.getTechHiringFee();
            int numTechs = unitSpace - p.getFreeBays();
            if ((techCost *= numTechs) > p.getMoney()) {
                String plural = "";
                if (numTechs == 1) {
                    plural = "s";
                }
                CampaignMain.cm.toUser("AM:You need to hire " + numTechs + " more technician" + plural + " in order to maintain this unit. Doing so would " + " cost " + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ", and you only have " + CampaignMain.cm.moneyOrFluMessage(true, true, p.getMoney()) + ".", Username, true);
                return;
            }
            String toReturn = "AM:You must hire " + numTechs + " more technicians in order to maintain this unit. Doing so will cost " + CampaignMain.cm.moneyOrFluMessage(true, true, techCost) + ".<br>";
            toReturn = toReturn + "AM:<a href=\"MEKWARS/c hireandmaintain#" + numTechs + "#" + numtoset + "\">Click here to hire the technicians and maintain the unit.</a>";
            CampaignMain.cm.toUser(toReturn, Username, true);
            return;
        }
        unitToSet.setStatus(1);
        CampaignMain.cm.toUser("PL|SB|" + p.getTotalMekBays(), Username, false);
        CampaignMain.cm.toUser("PL|SF|" + p.getFreeBays(), Username, false);
        CampaignMain.cm.toUser("PL|SUS|" + unitToSet.getId() + "#" + 1, Username, false);
        CampaignMain.cm.toUser(unitToSet.getPilot().getName() + "'s " + unitToSet.getModelName() + " is now being maintained.", Username, true);
        p.setSave();
    }
}

