/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetTargetSystemTypeCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int unitid = 0;
        int targetSystemType = 0;
        try {
            unitid = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:SetTargetSystemType command failed. Check your input. It should be something like this: /c SetTargetSystemType#unitid#targettype", Username, true);
            return;
        }
        try {
            targetSystemType = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:SetTargetSystemType command failed. Check your input. It should be something like this: /c SetTargetSystemType#unitid#targettype", Username, true);
            return;
        }
        if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(targetSystemType)) {
            CampaignMain.cm.toUser("AM:Your techs regret to inform you that your unit's electronics cannot support that type of targeting system.", Username, true);
            return;
        }
        SUnit unit = p.getUnit(unitid);
        Entity en = unit.getEntity();
        en.setTargSysType(targetSystemType);
        unit.setEntity(en);
        CampaignMain.cm.toUser("AM:Targeting Sytem set for " + unit.getModelName(), Username, true);
    }
}

