/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetUnitAmmoCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int unitid = 0;
        int weaponType = 0;
        String ammoName = "";
        int weaponLocation = 0;
        int shots = 100;
        boolean hotloaded = false;
        SUnit unit = null;
        SHouse faction = null;
        Entity en = null;
        boolean usingCrits = CampaignMain.cm.getBooleanConfig("UsePartsRepair");
        try {
            unitid = Integer.parseInt(command.nextToken());
            weaponLocation = Integer.parseInt(command.nextToken());
            weaponType = Integer.parseInt(command.nextToken());
            ammoName = command.nextToken();
            shots = Integer.parseInt(command.nextToken());
            hotloaded = Boolean.parseBoolean(command.nextToken());
            unit = p.getUnit(unitid);
            faction = p.getMyHouse();
            en = unit.getEntity();
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:SetUnitAmmo command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        catch (Exception e) {
            return;
        }
        int location = 0;
        Mounted mWeapon = null;
        for (Mounted Weapon : en.getAmmo()) {
            if (location == weaponLocation) {
                mWeapon = Weapon;
                break;
            }
            ++location;
        }
        if (mWeapon == null) {
            return;
        }
        AmmoType currAmmo = (AmmoType)mWeapon.getType();
        AmmoType at = unit.getEntityAmmo(weaponType, ammoName);
        if (mWeapon.isHotLoaded() != hotloaded) {
            mWeapon.setHotLoad(hotloaded);
            unit.setEntity(en);
            String result = at.getName() + "(" + en.getLocationAbbr(mWeapon.getLocation()) + ")";
            result = hotloaded ? result + " hot-loaded." : result + " safties engaged.";
            CampaignMain.cm.toUser(result, Username);
            CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
        }
        if (currAmmo.getInternalName().equalsIgnoreCase(at.getInternalName()) && shots == mWeapon.getShotsLeft()) {
            return;
        }
        if (shots == 0) {
            if (usingCrits) {
                p.updatePartsCache(currAmmo.getInternalName(), mWeapon.getShotsLeft());
            }
            mWeapon.changeAmmoType(at);
            mWeapon.setShotsLeft(0);
            unit.setEntity(en);
            CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
            p.checkAndUpdateArmies(unit);
            CampaignMain.cm.toUser("AM:Ammo dumped. BV Recalculated", Username, true);
            if (CampaignMain.cm.isUsingMySQL()) {
                unit.toDB();
            }
            return;
        }
        String munitionType = Long.toString(at.getMunitionType());
        double ammoCharge = CampaignMain.cm.getAmmoCost(at.getInternalName());
        if (CampaignMain.cm.getData().getServerBannedAmmo().get(munitionType) != null || faction.getBannedAmmo().get(munitionType) != null || ammoCharge < 0.0 && !usingCrits) {
            CampaignMain.cm.toUser("AM:<font color=green>Quartermaster Command regretfully informs you that " + at.getName() + " is out of stock.</font>", Username, true);
            return;
        }
        String strConfirm = "";
        if (command.hasMoreTokens()) {
            strConfirm = command.nextToken();
        }
        if (ammoCharge > 0.0 || usingCrits) {
            int refillShots = at.getShots();
            int shotsLeft = mWeapon.getShotsLeft();
            if (!currAmmo.getInternalName().equalsIgnoreCase(at.getInternalName())) {
                shotsLeft = 0;
            }
            if (shotsLeft == refillShots) {
                return;
            }
            if (mWeapon.getLocation() == -1) {
                refillShots = 1;
            } else {
                ammoCharge *= (double)(refillShots -= shotsLeft);
            }
            int loc = 0;
            if (mWeapon.getLocation() == -1) {
                Mounted linkedBy = mWeapon.getLinkedBy();
                loc = linkedBy.getLocation();
            } else {
                loc = mWeapon.getLocation();
            }
            if (usingCrits) {
                String result;
                ammoCharge = 0.0;
                p.getUnitParts().add(currAmmo.getInternalName(), mWeapon.getShotsLeft());
                int newAmmoAmount = p.getPartsAmount(at.getInternalName());
                if (p.getAutoReorder() && newAmmoAmount < refillShots) {
                    String newCommand = at.getInternalName() + "#" + (refillShots - newAmmoAmount);
                    CampaignMain.cm.getServerCommands().get("BUYPARTS").process(new StringTokenizer(newCommand, "#"), Username);
                    newAmmoAmount = p.getPartsAmount(at.getInternalName());
                }
                if (newAmmoAmount == 0) {
                    result = "After unloading " + currAmmo.getDesc() + "(" + en.getLocationAbbr(loc) + ") from unit #" + unit.getId() + " " + unit.getModelName() + " your techs realize you do not have any " + at.getDesc() + " to reload with!";
                    CampaignMain.cm.toUser(result, Username);
                } else if (newAmmoAmount < at.getShots()) {
                    result = "After unloading " + currAmmo.getDesc() + "(" + en.getLocationAbbr(loc) + ") from unit #" + unit.getId() + " " + unit.getModelName() + " your techs realize you only had " + newAmmoAmount + " rounds of " + at.getDesc() + " to reload with!";
                    CampaignMain.cm.toUser(result, Username);
                } else {
                    CampaignMain.cm.toUser("AM:Ammo set for " + unit.getModelName() + " (#" + unit.getId() + ").", Username, true);
                    newAmmoAmount = refillShots;
                }
                p.updatePartsCache(currAmmo.getInternalName(), mWeapon.getShotsLeft());
                p.updatePartsCache(at.getInternalName(), -newAmmoAmount);
                mWeapon.changeAmmoType(at);
                mWeapon.setShotsLeft(newAmmoAmount);
                unit.setEntity(en);
                p.checkAndUpdateArmies(unit);
                CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
                CampaignMain.cm.toUser("AM:Ammo set for " + unit.getModelName() + " (#" + unit.getId() + ").", Username, true);
                if (CampaignMain.cm.isUsingMySQL()) {
                    unit.toDB();
                }
                return;
            }
            int cost = (int)Math.ceil(ammoCharge);
            if (!strConfirm.equals("CONFIRM")) {
                String result = "AM:Quartermaster command will charge you " + CampaignMain.cm.moneyOrFluMessage(true, false, cost) + " to change the load out on #" + unit.getId() + " " + unit.getModelName() + "<br>from " + currAmmo.getDesc() + "(" + en.getLocationAbbr(loc) + " " + shotsLeft + "/" + currAmmo.getShots() + ") to " + at.getDesc() + "(" + refillShots + "/" + refillShots + ").";
                result = result + "<br><a href=\"MEKWARS/c setunitammo#" + unitid + "#" + weaponLocation + "#" + weaponType + "#" + ammoName + "#" + at.getShots() + "#" + hotloaded + "#CONFIRM";
                result = result + "\">Click here to change the ammo.</a>";
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            if (p.getMoney() < cost) {
                CampaignMain.cm.toUser("AM:Changing ammo costs " + CampaignMain.cm.moneyOrFluMessage(true, false, cost, false) + ", but you only have " + p.getMoney() + ".", Username, true);
                return;
            }
            p.addMoney(-cost);
        }
        mWeapon.changeAmmoType(at);
        unit.setEntity(en);
        p.checkAndUpdateArmies(unit);
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
        CampaignMain.cm.toUser("AM:Ammo set for " + unit.getModelName() + " (#" + unit.getId() + ").", Username, true);
        if (CampaignMain.cm.isUsingMySQL()) {
            unit.toDB();
        }
    }
}

