/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import megamek.common.VTOL;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetUnitCommanderCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int mechid = -1;
        int armyid = -1;
        boolean commander = false;
        try {
            mechid = Integer.parseInt(command.nextToken());
            armyid = Integer.parseInt(command.nextToken());
            commander = Boolean.parseBoolean(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Incorrect syntax. Try: /setUnitCommander unit ID#army ID#true/false", Username, true);
            return;
        }
        SUnit m = p.getUnit(mechid);
        SArmy army = p.getArmy(armyid);
        if (m == null) {
            CampaignMain.cm.toUser("AM:Could not find a unit with the given ID.", Username, true);
            return;
        }
        if (m.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:Units that are for sale on the Market.", Username, true);
            return;
        }
        if (m.getPilot() == null || m.getPilot().getName().equalsIgnoreCase("vacant")) {
            CampaignMain.cm.toUser("AM:This unit does not have a pilot to be a commander for!", Username);
            return;
        }
        if (!house.getBooleanConfig("allowUnitCommander" + SUnit.getTypeClassDesc(m.getType()))) {
            CampaignMain.cm.toUser(SUnit.getTypeClassDesc(m.getType()) + " units are not allowed to be set as unit commanders!", Username);
            return;
        }
        if (!house.getBooleanConfig("allowUnitCommanderVTOL") && m.getEntity() instanceof VTOL) {
            CampaignMain.cm.toUser("AM:VTOL units are not allowed to be set as unit commanders!", Username);
            return;
        }
        if (m.getEntity().isOffBoard()) {
            CampaignMain.cm.toUser("AM:Off board units are not allowed to be set as unit commanders!", Username);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(m.getId()) < 1) {
            CampaignMain.cm.toUser("AM:the " + m.getModelName() + " is not in any armies!", Username);
            return;
        }
        if (army.isCommander(m.getId()) && commander) {
            CampaignMain.cm.toUser("AM:" + m.getModelName() + " is already a unit commander for this army!", Username);
            return;
        }
        p.setSave();
        if (commander) {
            army.addCommander(m.getId());
            CampaignMain.cm.toUser("AM:Unit #" + m.getId() + " has been set as unit commander", Username);
        } else {
            CampaignMain.cm.toUser("AM:Unit #" + m.getId() + " has been removed as unit commander", Username);
            army.removeCommander(m.getId());
        }
        CampaignMain.cm.toUser("PL|SAD|" + army.toString(true, "%"), Username, false);
    }
}

