/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetUnmaintainedCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int numtoset = 0;
        try {
            numtoset = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:SetUnmaintained command failed. Check your input. It should be something like this: /c setunmaintained#12", Username, true);
            return;
        }
        SUnit unitToSet = p.getUnit(numtoset);
        if (unitToSet == null) {
            CampaignMain.cm.toUser("AM:Invalid id number. Make sure you're using the right unit number.", Username, true);
            return;
        }
        if (unitToSet.getStatus() == 2) {
            CampaignMain.cm.toUser("AM:This unit is already unmaintained.", Username, true);
            return;
        }
        if (unitToSet.getStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not change the maintenance status of a unit which is being sold.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not unmaintain a unit while active.", Username, true);
            return;
        }
        if (p.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You may not unmaintain a unit while engaged!.", Username, true);
            return;
        }
        unitToSet.setUnmaintainedStatus();
        CampaignMain.cm.toUser("PL|SUS|" + unitToSet.getId() + "#" + 2, Username, false);
        CampaignMain.cm.toUser("PL|SB|" + p.getTotalMekBays(), Username, false);
        CampaignMain.cm.toUser("PL|SF|" + p.getFreeBays(), Username, false);
        CampaignMain.cm.toUser(unitToSet.getPilot().getName() + "'s " + unitToSet.getModelName() + " is no longer being maintained.", Username, true);
        p.setSave();
    }
}

