/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.util.RepairTrackingThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepairCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    @Override
    public int getExecutionLevel() {
        return this.accessLevel;
    }

    @Override
    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        Vector<Integer> techs = new Vector<Integer>(7, 1);
        Vector<Integer> rolls = new Vector<Integer>(7, 1);
        try {
            int unitID = Integer.parseInt(command.nextToken());
            techs.add(-999);
            rolls.add(-999);
            for (int type = 0; type < 6; ++type) {
                techs.add(Integer.parseInt(command.nextToken()));
                rolls.add(Integer.parseInt(command.nextToken()));
            }
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SUnit unit = player.getUnit(unitID);
            Pilot pilot = unit.getPilot();
            int ATLevel = 0;
            if (pilot.getSkills().has(2)) {
                ATLevel = pilot.getSkills().getPilotSkill(2).getLevel();
            }
            int cost = CampaignMain.cm.getTotalRepairCosts(unit.getEntity(), techs, rolls, ATLevel, player.getMyHouse());
            int time = 0;
            if (player.isUnitInLockedArmy(unitID)) {
                CampaignMain.cm.toUser("FSM|Sorry but that unit is currently in combat and may not be repaired.", Username, false);
                return;
            }
            if (cost > player.getMoney()) {
                CampaignMain.cm.toUser("FSM|You do not have enough " + CampaignMain.cm.moneyOrFluMessage(true, false, -cost) + " to repair this location.", Username, false);
                return;
            }
            if (player.getDutyStatus() == 3 && player.getAmountOfTimesUnitExistsInArmies(unitID) > 0) {
                CampaignMain.cm.toUser("FSM|You man not repair that unit while it is in an active army.", Username, false);
                return;
            }
            for (int type = 1; type <= 6; ++type) {
                int numberOfTechs = 1;
                int techType = techs.elementAt(type);
                if (techType < 4) {
                    numberOfTechs = player.getAvailableTechs().elementAt(techType);
                }
                if (techType == 4 && unit.getPilot() != null && unit.getLastCombatPilot() != unit.getPilot().getPilotId()) {
                    CampaignMain.cm.toUser("FSM|" + unit.getPilot().getName() + " refuses to repair a unit he does not remember damaging himself!", Username, false);
                    return;
                }
                if (techType == 4) {
                    unit.setPilotIsRepairing(true);
                }
                if (numberOfTechs > 0) continue;
                CampaignMain.cm.toUser("FSM|You do not have any " + UnitUtils.techDescription(techType) + " techs to do this repair!", Username, false);
                return;
            }
            if (CampaignMain.cm.getRTT().getState() == Thread.State.TERMINATED) {
                CampaignMain.cm.toUser("FSM|Sorry your repair order could not be processed the repair thread has been terminated. Staff has been notified.", Username, false);
                CampaignData.mwlog.errLog("AM:NOTE: Repair Thread has been terminated! Use the restartrepairthread command to restart it! If all else fails reboot!");
                return;
            }
            player.addMoney(-cost);
            unit.addRepairCost(cost);
            unit.addRepairCost(-1);
            player.setSave();
            time = this.setWorkHours(rolls, techs, unit.getEntity(), player.getMyHouse());
            CampaignData.mwlog.errLog("Repair Time: " + time);
            CampaignMain.cm.getRTT().getRepairList().add(RepairTrackingThread.Repair(player, unitID, techs, time, false));
            CampaignMain.cm.toUser("FSM|Repairs have begone on your " + unit.getModelName() + " <b>At a Cost of " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + "</b>", Username, false);
            CampaignMain.cm.toUser("PL|UU|" + unitID + "|" + unit.toString(true), Username, false);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to Process Repair Unit Command!");
            CampaignData.mwlog.errLog(ex);
        }
    }

    private int setWorkHours(Vector<Integer> rolls, Vector<Integer> techs, Entity unit, SHouse house) {
        int totalTime = 0;
        boolean engineFound = false;
        for (int location = 0; location < unit.locations(); ++location) {
            int baseRoll;
            int techType;
            if (unit.getArmor(location) != unit.getOArmor(location)) {
                techType = techs.elementAt(1);
                baseRoll = rolls.elementAt(1);
                totalTime += this.calculateTime(unit, location, 13, techType, baseRoll, true, house);
            }
            if (unit.hasRearArmor(location) && unit.getArmor(location, true) != unit.getOArmor(location, true)) {
                techType = techs.elementAt(1);
                baseRoll = rolls.elementAt(1);
                totalTime += this.calculateTime(unit, location, 14, techType, baseRoll, true, house);
            }
            if (unit.getInternal(location) != unit.getOInternal(location)) {
                techType = techs.elementAt(2);
                baseRoll = rolls.elementAt(2);
                totalTime += this.calculateTime(unit, location, 15, techType, baseRoll, true, house);
            }
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                CriticalSlot cs = unit.getCritical(location, slot);
                if (cs == null || !cs.isBreached() && !cs.isDamaged()) continue;
                if (cs.getType() == 0 && cs.getIndex() != 3) {
                    techType = techs.elementAt(5);
                    baseRoll = rolls.elementAt(5);
                    totalTime += this.calculateTime(unit, location, slot, techType, baseRoll, false, house);
                    slot += Math.max(0, UnitUtils.getNumberOfCrits(unit, cs) - 1);
                    continue;
                }
                if (cs.getType() == 0 && cs.getIndex() == 3 && !engineFound) {
                    techType = techs.elementAt(6);
                    baseRoll = rolls.elementAt(6);
                    totalTime += this.calculateTime(unit, location, slot, techType, baseRoll, false, house);
                    engineFound = true;
                }
                if (cs.getType() != 1) continue;
                Mounted mounted = unit.getEquipment(cs.getIndex());
                if (!(mounted.getType() instanceof WeaponType)) {
                    techType = techs.elementAt(4);
                    baseRoll = rolls.elementAt(4);
                } else {
                    techType = techs.elementAt(3);
                    baseRoll = rolls.elementAt(3);
                }
                totalTime += this.calculateTime(unit, location, slot, techType, baseRoll, false, house);
                slot += Math.max(0, UnitUtils.getNumberOfCrits(unit, cs) - 1);
            }
        }
        return totalTime;
    }

    private int calculateTime(Entity unit, int location, int slot, int tech, int baseRoll, boolean armor, SHouse house) {
        int roll = 0;
        int repairTime = CampaignMain.cm.getIntegerConfig("TimeForEachRepairPoint");
        roll = UnitUtils.getTechRoll(unit, location, slot, tech, armor, house.getTechLevel()) - baseRoll;
        if (!armor) {
            CriticalSlot cs = unit.getCritical(location, slot);
            int totalCrits = UnitUtils.getNumberOfCrits(unit, cs);
            repairTime *= totalCrits;
        }
        for (int count = 0; count < roll; ++count) {
            repairTime *= 2;
        }
        repairTime = (int)((double)repairTime * this.timeIncreaseBasedOnRoll(baseRoll));
        return repairTime;
    }

    private double timeIncreaseBasedOnRoll(int roll) {
        if (roll <= 2) {
            return 1.0;
        }
        if (roll > 12) {
            return 36.0;
        }
        double[] payout = new double[]{1.0, 1.0, 1.0, 1.03, 1.09, 1.2, 1.38, 1.72, 2.4, 3.6, 5.92, 12.0, 36.0};
        return payout[roll];
    }
}

