/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class StopRepairJobCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            int unitID = Integer.parseInt(command.nextToken());
            int location = Integer.parseInt(command.nextToken());
            int slot = Integer.parseInt(command.nextToken());
            boolean armor = Boolean.parseBoolean(command.nextToken());
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SUnit unit = player.getUnit(unitID);
            if (!CampaignMain.cm.getRTT().isBeingRepaired(unitID, location, slot, armor)) {
                CampaignMain.cm.toUser("FSM|There is no repair order for this section at the present.", Username, false);
                return;
            }
            if (CampaignMain.cm.getRTT().getState() == Thread.State.TERMINATED) {
                CampaignMain.cm.toUser("FSM|Sorry your repair order could not be processed - the repair thread terminated. Staff was notified.", Username, false);
                CampaignData.mwlog.errLog("NOTE: Repair Thread terminated! Use the restartrepairthread command to restart the thread. If all else fails reboot!");
                return;
            }
            CampaignMain.cm.getRTT().stopRepair(unitID, location, slot, armor);
            CampaignMain.cm.toUser("PL|UU|" + unitID + "|" + unit.toString(true), Username, false);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("AM:Unable to Process Repair Unit Command!");
            CampaignData.mwlog.errLog(ex);
        }
    }
}

