/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class TransferMoneyCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int amount;
        String targetPlayer;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        if (player == null) {
            CampaignMain.cm.toUser("AM:Null player (" + Username + ") in transfermoney. Report to an admin.", Username, true);
            return;
        }
        if (player.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:You may not transfer " + house.getConfig("MoneyLongName") + " while in a training faction.", Username, true);
            return;
        }
        try {
            targetPlayer = (String)command.nextElement();
            amount = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c transferunit#TargetPlayer#UnitID", Username, true);
            return;
        }
        SPlayer targetplayer = CampaignMain.cm.getPlayer(targetPlayer);
        if (targetplayer == null) {
            CampaignMain.cm.toUser("AM:Could not find a player named " + targetPlayer + ".", Username, true);
            return;
        }
        if (amount < 1) {
            CampaignMain.cm.toUser("AM:You must transfer at least 1 " + house.getConfig("MoneyLongName") + ".", Username, true);
            return;
        }
        boolean ipcheck = Boolean.parseBoolean(house.getConfig("IPCheck"));
        if (ipcheck && CampaignMain.cm.getServer().getIP(player.getName()).toString().equals(CampaignMain.cm.getServer().getIP(targetplayer.getName()).toString())) {
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + " has the same IP as you do. You can't send them " + house.getConfig("MoneyLongName"), Username, true);
            return;
        }
        if (!targetplayer.getHouseFightingFor().equals(player.getMyHouse()) && !targetplayer.getMyHouse().equals(player.getMyHouse())) {
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + " is not from your faction! You can't send them " + house.getConfig("MoneyLongName"), Username, true);
            return;
        }
        if (player.getMoney() - Integer.parseInt(house.getConfig("WelfareCeiling")) <= amount) {
            CampaignMain.cm.toUser("AM:You may not send that much money!", Username, true);
            return;
        }
        player.addMoney(-amount);
        targetplayer.addMoney(amount);
        CampaignMain.cm.toUser("AM:You've transferred " + CampaignMain.cm.moneyOrFluMessage(true, true, amount) + " to " + targetplayer.getName(), Username, true);
        CampaignMain.cm.toUser("AM:" + player.getName() + " sends you " + CampaignMain.cm.moneyOrFluMessage(true, true, amount) + ".", targetPlayer, true);
    }
}

