/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class TransferPilotCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        if (!new Boolean(house.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            CampaignMain.cm.toUser("AM:Pilot queues are not enabled on this server.", Username, true);
            return;
        }
        if (player.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("AM:You may not transfer any of your pilots while you are on welfare.", Username, true);
            return;
        }
        if (player.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:Players in " + player.getMyHouse().getName() + " may not transfer pilots.", Username, true);
            return;
        }
        String targetPlayer = (String)command.nextElement();
        int pUnitType = Integer.parseInt((String)command.nextElement());
        int pWeightClass = Integer.parseInt((String)command.nextElement());
        int pPosition = Integer.parseInt((String)command.nextElement());
        SPlayer targetplayer = CampaignMain.cm.getPlayer(targetPlayer);
        if (targetplayer == null) {
            CampaignMain.cm.toUser("AM:Unknown Target Player", Username, true);
            return;
        }
        if (targetplayer.getPersonalPilotQueue().getPilotQueue(pUnitType, pWeightClass).size() + 1 > Integer.parseInt(house.getConfig("MaxAllowedPilotsInQueueToBuyFromHouse"))) {
            CampaignMain.cm.toUser("AM:" + Username + " tried to send you a pilot, but your faction allows only " + new Integer(house.getConfig("MaxAllowedPilotsInQueueToBuyFromHouse")) + " pilots of each type in your barracks.", targetplayer.getName(), true);
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + "'s barracks are currently full!", Username, true);
            return;
        }
        SPilot pilot = (SPilot)player.getPersonalPilotQueue().getPilot(pUnitType, pWeightClass, pPosition);
        if (pilot == null) {
            CampaignMain.cm.toUser("AM:Unable to find that Pilot. Try again", Username);
            return;
        }
        if (!targetplayer.getMyHouse().equals(player.getMyHouse()) && !targetplayer.getMyHouse().getHouseFightingFor(targetplayer).equals(player.getMyHouse())) {
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + " is not in your faction. You cannot send him units.", Username, true);
            player.getPersonalPilotQueue().addPilot(pilot, pWeightClass);
            return;
        }
        if (!targetplayer.getMyHouse().isLoggedIntoFaction(targetplayer.getName())) {
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + " is not logged in. You may only transfer to players who are online.", Username, true);
            player.getPersonalPilotQueue().addPilot(pilot, pWeightClass);
            return;
        }
        if (new Boolean(house.getConfig("IPCheck")).booleanValue() && CampaignMain.cm.getServer().getIP(player.getName()).toString().equals(CampaignMain.cm.getServer().getIP(targetplayer.getName()).toString())) {
            CampaignMain.cm.toUser("AM:" + targetplayer.getName() + " has the same IP as you do. You can't send them pilots.", Username, true);
            player.getPersonalPilotQueue().addPilot(pilot, pWeightClass);
            return;
        }
        targetplayer.getPersonalPilotQueue().addPilot(pilot, pWeightClass);
        CampaignMain.cm.toUser("PL|RPPPQ|" + pUnitType + "|" + pWeightClass + "|" + pPosition, Username, false);
        CampaignMain.cm.toUser("PL|AP2PPQ|" + pUnitType + "|" + pWeightClass + "|" + pilot.toFileFormat("#", true), targetPlayer, false);
        String description = "";
        description = pUnitType == 0 || pUnitType == 1 ? "[" + pilot.getGunnery() + "/" + pilot.getPiloting() : "[" + pilot.getGunnery();
        String skills = pilot.getSkillString(true);
        if (!skills.equals(" ")) {
            description = description + skills;
        }
        description = description.trim() + "]";
        CampaignMain.cm.toUser("AM:You transferred a " + Unit.getTypeClassDesc(pUnitType) + " pilot, " + pilot.getName() + " " + description + ", to " + targetplayer.getName() + ".", Username, true);
        CampaignMain.cm.toUser("AM:" + player.getName() + " transferred a " + Unit.getTypeClassDesc(pUnitType) + "pilot, " + pilot.getName() + " " + description + ", to your command.", targetPlayer, true);
    }
}

