/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.UnitFactory;
import java.io.File;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class UnenrollCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (Username.startsWith("Nobody")) {
            CampaignMain.cm.toUser("AM:Nobodies can't enroll, hence they can't unenroll. Nice try though.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Couldn't find your player to unenroll. Contact an admin immediately.", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("AM:You didn't confirm the Unenroll command. Enter /c unenroll#confirm if you're absolutely sure you want to quit.", Username, true);
            return;
        }
        String confirmString = command.nextToken();
        if (!confirmString.equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("AM:You didn't confirm the Unenroll Command. Enter /c unenroll#confirm if you're absolutely sure you want to quit.", Username, true);
            return;
        }
        if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null || p.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You cannot unenroll while in a game.", Username, true);
            return;
        }
        if (p.getExperience() == 0) {
            CampaignMain.cm.toUser("AM:You cannot unenroll with 0 XP. Ask an admin or mod to remove your account.", Username, true);
            return;
        }
        if (CampaignMain.cm.getMarket().hasActiveListings(p)) {
            CampaignMain.cm.toUser("AM:You cannot unenroll while you have units on the Market. Recall them and try again.", Username, true);
            return;
        }
        if (p.hasRepairingUnits(false)) {
            CampaignMain.cm.toUser("AM:You cannot unenroll while repairing units. Cancel the repairs and try again.", Username, true);
            return;
        }
        SHouse hisfaction = CampaignMain.cm.getHouseForPlayer(Username);
        if (hisfaction == null) {
            CampaignMain.cm.toUser("AM:Couldn't find faction to unenroll. Contact an admin immediately.", Username, true);
            return;
        }
        if (CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.MySQL.removeUserFromHouseForum(p.getForumID(), hisfaction.getForumID());
        }
        hisfaction.removePlayer(p, CampaignMain.cm.getBooleanConfig("DonateUnitsUponUnenrollment"));
        CampaignMain.cm.toUser("AM:You've been unenrolled.", Username, true);
        this.removeFaction(hisfaction);
        File fp = new File("./campaign/players/" + p.getName().toLowerCase() + ".dat");
        if (fp.exists()) {
            fp.delete();
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deletePlayer(p, false);
        }
        InetAddress ip = CampaignMain.cm.getServer().getIP(Username);
        CampaignData.mwlog.ipLog("UNENROLL: " + Username + " IP: " + ip);
        CampaignMain.cm.doSendModMail("NOTE", Username + " unenrolled from the campaign (IP: " + ip + ").");
    }

    private void removeFaction(SHouse faction) {
        if (!CampaignMain.cm.getBooleanConfig("AllowSinglePlayerFactions")) {
            return;
        }
        Enumeration<SPlanet> planets = faction.getPlanets().elements();
        while (planets.hasMoreElements()) {
            SPlanet planet = planets.nextElement();
            planet.doGainInfluence(CampaignMain.cm.getHouseById(-1), faction, Integer.MAX_VALUE, true);
            Enumeration<UnitFactory> factories = planet.getUnitFactories().elements();
            while (factories.hasMoreElements()) {
                UnitFactory factory = factories.nextElement();
                if (!factory.getFounder().equalsIgnoreCase(faction.getName())) continue;
                planet.getUnitFactories().removeElement(factory);
            }
            planet.setBaysProvided(0);
            planet.updated();
            planet.updateInfluences();
        }
        CampaignMain.cm.getData().removeHouse(faction.getId());
        CampaignMain.cm.updateHousePlanetUpdate();
        CampaignMain.cm.doSendToAllOnlinePlayers("PL|RPF|" + faction.getId(), false);
    }
}

