/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class UnitPositionCommand
implements Command {
    String syntax = "";

    public int getExecutionLevel() {
        return 0;
    }

    public void setExecutionLevel(int i) {
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
            CampaignMain.cm.toUser("AM:You may not change unit positions while you are in a game!", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            int armyid = -1;
            int unitid = -1;
            int newposition = -1;
            try {
                armyid = Integer.parseInt((String)command.nextElement());
                unitid = Integer.parseInt((String)command.nextElement());
                newposition = Integer.parseInt((String)command.nextElement());
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("AM:Improper format. Try: /c unitposition#army#unit#newposition", Username, true);
                return;
            }
            SArmy a = p.getArmy(armyid);
            if (a == null) {
                CampaignMain.cm.toUser("AM:You do not have an Army with ID #" + armyid + ".", Username, true);
                return;
            }
            if (a.isLocked()) {
                CampaignMain.cm.toUser("AM:Army #" + armyid + " is locked.", Username, true);
                return;
            }
            SUnit u = p.getUnit(unitid);
            if (u == null) {
                CampaignMain.cm.toUser("AM:You do not have a Unit with ID #" + unitid + ".", Username, true);
                return;
            }
            if (u.getStatus() == 2) {
                CampaignMain.cm.toUser("AM:You may not change the position of an unmaintained unit.", Username, true);
                return;
            }
            if (newposition < 0) {
                CampaignMain.cm.toUser("AM:You may not place a unit in a negative order/position.", Username, true);
                return;
            }
            if (newposition > a.getAmountOfUnits()) {
                CampaignMain.cm.toUser("AM:Highest position available in Army #" + armyid + " is Pos. #" + a.getAmountOfUnits() + ".", Username, true);
                return;
            }
            if (a.isPlayerLocked()) {
                CampaignMain.cm.toUser("AM:You cannot modify a locked army.", Username, true);
                return;
            }
            a.removeUnit(unitid);
            if (newposition >= a.getAmountOfUnits()) {
                a.addUnit(u);
            } else {
                a.addUnit(u, newposition);
            }
            CampaignMain.cm.toUser("PL|RPU|" + a.getID() + "#" + u.getId() + "#" + newposition, Username, false);
            CampaignMain.cm.toUser("AM:Army #" + a.getID() + "'s order was changed. The " + u.getModelName() + "  is now Unit " + (newposition + 1) + ".", Username, true);
            p.setSave();
        }
    }
}

