/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.Unit;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseRewardPointsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    @Override
    public int getExecutionLevel() {
        return this.accessLevel;
    }

    @Override
    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int rewardSelection = Integer.parseInt(command.nextToken());
        int rewardPoints = 0;
        String techs = "";
        String rewards = "";
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        if (rewardSelection < 0 || rewardSelection > 3) {
            CampaignMain.cm.toUser("AM:Invalid reward selection. 0 for techs, 1 for influence, 2 for units, 3 for repair.", Username, true);
            return;
        }
        switch (rewardSelection) {
            case 0: {
                rewardPoints = Integer.parseInt(command.nextToken());
                if (rewardPoints < 0) {
                    CampaignMain.cm.toUser("AM:Invalid input - negative reward points.", Username, true);
                    return;
                }
                if (!new Boolean(house.getConfig("AllowTechsForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("AM:Sorry but you are not allowed to buy techs with reward points.", Username, true);
                    return;
                }
                if (rewardPoints > player.getReward()) {
                    if (player.getReward() == 1) {
                        CampaignMain.cm.toUser("AM:You only have 1 reward point. Try again later.", Username, true);
                    } else {
                        CampaignMain.cm.toUser("AM:You only have " + player.getReward() + " reward points. Try again later.", Username, true);
                    }
                    return;
                }
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    int typeOfTechToBuy = rewardPoints;
                    int techCost = Integer.parseInt(house.getConfig("RewardPointsFor" + UnitUtils.techDescription(typeOfTechToBuy)));
                    if (player.getReward() < techCost) {
                        CampaignMain.cm.toUser("AM:You do not have enough reward points to buy this tech. You need " + techCost, Username, true);
                        return;
                    }
                    player.addReward(-techCost);
                    player.addTotalTechs(typeOfTechToBuy, 1);
                    player.addAvailableTechs(typeOfTechToBuy, 1);
                    if (techCost > 1) {
                        rewards = "s";
                    }
                    CampaignMain.cm.toUser("AM:You hired " + StringUtils.aOrAn(UnitUtils.techDescription(typeOfTechToBuy), true) + " tech for " + techCost + "RP" + rewards + ".", Username, true);
                    break;
                }
                int numOfTechBought = Integer.parseInt(house.getConfig("TechsForARewardPoint"));
                if ((numOfTechBought *= rewardPoints) > 1) {
                    techs = "s";
                }
                if (rewardPoints > 1) {
                    rewards = "s";
                }
                CampaignMain.cm.toUser("AM:You hired " + numOfTechBought + " tech" + techs + " for " + rewardPoints + " reward point" + rewards + ".", Username, true);
                player.addReward(-rewardPoints);
                player.addTechnicians(numOfTechBought);
                break;
            }
            case 1: {
                rewardPoints = Integer.parseInt(command.nextToken());
                if (rewardPoints < 0) {
                    CampaignMain.cm.toUser("AM:Invalid input - negative reward points.", Username, true);
                    return;
                }
                if (!new Boolean(house.getConfig("AllowInfluenceForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("Sorry but you are not allowed to buy influence with reward points.", Username, true);
                    return;
                }
                if (rewardPoints > player.getReward()) {
                    if (player.getReward() == 0) {
                        CampaignMain.cm.toUser("AM:You don't have any reward points. Purchase fails.", Username, true);
                    } else {
                        String toSend = "AM:You only have " + player.getReward() + "reward point" + StringUtils.addAnS(player.getReward()) + ". Try again.";
                        CampaignMain.cm.toUser(toSend, Username, true);
                    }
                    return;
                }
                int amountOfInfluenceBought = Integer.parseInt(house.getConfig("InfluenceForARewardPoint"));
                CampaignMain.cm.toUser("AM:You've bought " + CampaignMain.cm.moneyOrFluMessage(false, true, amountOfInfluenceBought *= rewardPoints) + " for " + rewardPoints + " reward point" + StringUtils.addAnS(rewardPoints) + ".", Username, true);
                player.addReward(-rewardPoints);
                player.addInfluence(amountOfInfluenceBought);
                break;
            }
            case 2: {
                if (!new Boolean(house.getConfig("AllowUnitsForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("AM:Sorry but you are not allowed to buy units with reward points.", Username, true);
                    return;
                }
                int rewardPointsAvailable = player.getReward();
                int unitTotalRewardPointCost = 0;
                String typestring = command.nextToken();
                String weightstring = command.nextToken();
                int unitType = 0;
                int unitWeight = 0;
                int typeCost = Integer.parseInt(house.getConfig("RewardPointsForAMek"));
                int weightCost = Integer.parseInt(house.getConfig("RewardPointsForALight"));
                SHouse faction = player.getHouseFightingFor();
                double rareCost = 1.0;
                boolean buyRareUnit = false;
                Vector<SUnit> newUnits = new Vector<SUnit>(1, 1);
                SPilot newPilot = null;
                String factionstring = "common";
                if (house.getBooleanConfig("AllowRareUnitsForRewards")) {
                    rareCost = house.getDoubleConfig("RewardPointMultiplierForRare");
                }
                try {
                    unitType = Integer.parseInt(typestring);
                }
                catch (Exception ex) {
                    unitType = Unit.getTypeIDForName(typestring);
                }
                try {
                    unitWeight = Integer.parseInt(weightstring);
                }
                catch (Exception ex) {
                    unitWeight = Unit.getWeightIDForName(weightstring.toUpperCase());
                }
                if (command.hasMoreElements()) {
                    factionstring = command.nextToken();
                    if (factionstring.equalsIgnoreCase("rare")) {
                        if (!new Boolean(house.getConfig("AllowRareUnitsForRewards")).booleanValue()) {
                            CampaignMain.cm.toUser("AM:Sorry. You are not allowed to buy rare units with your reward points.", Username, true);
                            return;
                        }
                        buyRareUnit = true;
                        factionstring = house.getConfig("RewardsRareBuildTable");
                    } else if (!factionstring.equalsIgnoreCase("common")) {
                        faction = CampaignMain.cm.getHouseFromPartialString(factionstring, Username);
                    }
                    if (faction == null && (faction = player.getHouseFightingFor()) == null) {
                        factionstring = "Common";
                    }
                }
                switch (unitType) {
                    case 0: {
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForAMek"));
                        break;
                    }
                    case 1: {
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForAVeh"));
                        if (!new Boolean(house.getConfig("UseOnlyOneVehicleSize")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 2: {
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForInf"));
                        if (!new Boolean(house.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 3: {
                        if (faction.getTechLevel() < 2) {
                            CampaignMain.cm.toUser(faction.getName() + " is unable to produce Proto Meks!", Username);
                            return;
                        }
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForProto"));
                        if (!new Boolean(house.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 4: {
                        if (faction.getTechLevel() < 1) {
                            CampaignMain.cm.toUser(faction.getName() + " is unable to produce Battle Armor!", Username);
                            return;
                        }
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForBA"));
                        if (!new Boolean(house.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 5: {
                        typeCost = Integer.parseInt(house.getConfig("RewardPointsForAero"));
                    }
                }
                switch (unitWeight) {
                    case 0: {
                        weightCost = Integer.parseInt(house.getConfig("RewardPointsForALight"));
                        break;
                    }
                    case 1: {
                        weightCost = Integer.parseInt(house.getConfig("RewardPointsForAMed"));
                        break;
                    }
                    case 2: {
                        weightCost = Integer.parseInt(house.getConfig("RewardPointsForAHeavy"));
                        break;
                    }
                    case 3: {
                        weightCost = Integer.parseInt(house.getConfig("RewardPointsForAnAssault"));
                    }
                }
                unitTotalRewardPointCost = weightCost + typeCost;
                if (!player.getHouseFightingFor().equals(faction)) {
                    double nonHouseUnitMod = Double.parseDouble(house.getConfig(player.getHouseFightingFor().getName() + "To" + faction.getName() + "RewardPointMultiplier"));
                    if (nonHouseUnitMod < 0.0) {
                        nonHouseUnitMod = Double.parseDouble(house.getConfig("RewardPointNonHouseMultiplier"));
                    }
                    if (nonHouseUnitMod > 0.0) {
                        unitTotalRewardPointCost = (int)((double)unitTotalRewardPointCost * nonHouseUnitMod);
                    }
                }
                if (buyRareUnit) {
                    unitTotalRewardPointCost = (int)((double)unitTotalRewardPointCost * rareCost);
                }
                if (unitTotalRewardPointCost > rewardPointsAvailable) {
                    CampaignMain.cm.toUser("AM:Sorry. You need more reward points to buy that kind of unit.", Username, true);
                    return;
                }
                try {
                    newPilot = new Boolean(house.getConfig("AllowPersonalPilotQueues")) != false && (unitType == 0 || unitType == 3) ? new SPilot("Vacant", 99, 99) : player.getMyHouse().getNewPilot(unitType);
                    newUnits.addAll(this.getUnitProduced(unitType, unitWeight, newPilot, factionstring, player.getMyHouse()));
                    for (SUnit newUnit : newUnits) {
                        player.addUnit(newUnit, true);
                        CampaignMain.cm.toUser("AM:You've bought a " + newUnit.getModelName() + " for " + unitTotalRewardPointCost + " reward points.", Username, true);
                    }
                    player.addReward(-unitTotalRewardPointCost);
                }
                catch (Exception ex) {
                    CampaignMain.cm.toUser("AM:An error has occured while trying to create your requested unit. Please contact an admin. Faction: " + factionstring + " Type: " + unitType + " Class: " + unitWeight, Username, true);
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Error creating unit in " + this.getClass().getName());
                }
                break;
            }
            case 3: {
                rewardPoints = Integer.parseInt(house.getConfig("RewardPointsForRepair"));
                if (rewardPoints > player.getReward()) {
                    CampaignMain.cm.toUser("AM:You need more reward points to repair this unit (requires " + rewardPoints + " RP)", Username, true);
                    return;
                }
                int unitID = Integer.parseInt(command.nextToken());
                SUnit unit = player.getUnit(unitID);
                if (unit == null) {
                    CampaignMain.cm.toUser("AM:You don't have a unit with ID# " + unitID + ".", Username, true);
                    return;
                }
                Entity entity = unit.getEntity();
                if (entity.getInternal(1) < 1) {
                    CampaignMain.cm.toUser("AM:Sorry but cored units cannot be repaired with reward points!", Username);
                    return;
                }
                for (int x = 0; x < entity.locations(); ++x) {
                    entity.setArmor(entity.getOArmor(x), x);
                    if (entity.hasRearArmor(x)) {
                        entity.setArmor(entity.getOArmor(x, true), x, true);
                    }
                    entity.setInternal(entity.getOInternal(x), x);
                    for (int y = 0; y < entity.getNumberOfCriticals(x); ++y) {
                        CriticalSlot cs = entity.getCritical(x, y);
                        if (cs == null) continue;
                        if (cs.getType() == 1) {
                            Mounted mounted = entity.getEquipment(cs.getIndex());
                            UnitUtils.repairEquipment(mounted, entity, x);
                            continue;
                        }
                        if (UnitUtils.isEngineCrit(cs)) {
                            UnitUtils.repairDamagedEngine(entity);
                            continue;
                        }
                        if (entity instanceof Mech) {
                            UnitUtils.fixCriticalSlot(cs, entity, true);
                            UnitUtils.fixCriticalSlot(cs, entity, false);
                        }
                        entity.setCritical(x, y, cs);
                    }
                }
                for (Mounted weap : entity.getAmmo()) {
                    weap.setShotsLeft(((AmmoType)weap.getType()).getShots());
                }
                CampaignMain.cm.toUser("AM:Unit #" + unitID + " " + unit.getModelName() + " is now fully repaired.", Username, true);
                CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
                player.addReward(-rewardPoints);
                player.checkAndUpdateArmies(unit);
                player.setSave();
            }
        }
    }

    private Vector<SUnit> getUnitProduced(int type_id, int weightClass, SPilot pilot, String faction, SHouse house) {
        SUnitFactory factory = new SUnitFactory();
        String unitSize = Unit.getWeightClassDesc(weightClass);
        factory.setFounder(faction);
        Vector<SUnit> units = new Vector<SUnit>(1, 1);
        String Filename = "";
        String producer = "Reward Unit";
        if (new Boolean(house.getConfig("UseOnlyOneVehicleSize")).booleanValue() && type_id == 1) {
            unitSize = Unit.getWeightClassDesc(CampaignMain.cm.getRandomNumber(4));
        }
        if ((Filename = BuildTable.getUnitFilename(faction, unitSize, type_id, "reward")).toLowerCase().endsWith(".mul")) {
            units.addAll(SUnit.createMULUnits(Filename, producer));
        } else {
            SUnit cm = new SUnit(producer, Filename, weightClass);
            cm.setPilot(pilot);
            units.add(cm);
        }
        factory = null;
        return units;
    }
}

